/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueImpl;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.MarineLitterBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.batch.BatchPersistenceHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service(value="marineLitterBatchPersistenceService")
public class MarineLitterBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements MarineLitterBatchPersistenceService {
    private static final Log log = LogFactory.getLog(MarineLitterBatchPersistenceServiceImpl.class);
    @Autowired
    protected ReferentialPersistenceService referentialService;
    @Autowired
    protected AttachmentPersistenceService attachmentPersistenceService;
    @Resource(name="catchBatchDao")
    protected CatchBatchExtendDao catchBatchDao;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;
    protected Integer marineLitterCategory;
    protected Integer marineLitterSizeCategory;
    protected Map<Integer, CaracteristicQualitativeValue> marineLitterCategoryCaracteristicValues;
    protected Map<Integer, CaracteristicQualitativeValue> marineLitterSizeCategoryCaracteristicValues;

    @Override
    public void init() {
        super.init();
        Caracteristic marineLitterCategoryCaracteristic = this.referentialService.getMarineLitterCategoryCaracteristic();
        this.marineLitterCategory = marineLitterCategoryCaracteristic.getIdAsInt();
        this.marineLitterCategoryCaracteristicValues = TuttiEntities.splitByIdAsInt(marineLitterCategoryCaracteristic.getQualitativeValue());
        Caracteristic marineLitterSizeCategoryCaracteristic = this.referentialService.getMarineLitterSizeCategoryCaracteristic();
        this.marineLitterSizeCategory = marineLitterSizeCategoryCaracteristic.getIdAsInt();
        this.marineLitterSizeCategoryCaracteristicValues = TuttiEntities.splitByIdAsInt(marineLitterSizeCategoryCaracteristic.getQualitativeValue());
    }

    @Override
    public BatchContainer<MarineLitterBatch> getRootMarineLitterBatch(String fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        Integer catchBatchId = this.catchBatchDao.getIdByFishingOperationId(Integer.valueOf(fishingOperationId));
        Preconditions.checkNotNull((Object)catchBatchId);
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        Preconditions.checkNotNull((Object)catchBatch);
        SortingBatch vracMarineLitterBatch = this.getMarineLitterParentBatch(catchBatch);
        BatchContainer<MarineLitterBatch> result = new BatchContainer<MarineLitterBatch>();
        result.setId(vracMarineLitterBatch.getId());
        for (Batch batch1 : vracMarineLitterBatch.getChildBatchs()) {
            SortingBatch source = (SortingBatch)batch1;
            MarineLitterBatch target = TuttiBeanFactory.newMarineLitterBatch();
            this.entityToMarineLitterBatch(source, target);
            result.addChildren(target);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Loaded CatchBatch MarineLetter > " + target.getMarineLitterCategory().getName() + " / " + target.getMarineLitterSizeCategory().getName() + " : " + target.getId()));
        }
        return result;
    }

    @Override
    public MarineLitterBatch createMarineLitterBatch(MarineLitterBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        Preconditions.checkNotNull((Object)bean.getMarineLitterCategory());
        Preconditions.checkNotNull((Object)bean.getMarineLitterSizeCategory());
        Preconditions.checkNotNull((Object)bean.getNumber());
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        Integer catchBatchId = this.catchBatchDao.getIdByFishingOperationId(bean.getFishingOperation().getIdAsInt());
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        SortingBatch batch = SortingBatch.Factory.newInstance();
        this.marineLitterBatchToEntity(bean, batch, catchBatch);
        batch = this.catchBatchDao.createSortingBatch(batch, catchBatch);
        bean.setId(batch.getId());
        this.getCurrentSession().flush();
        return bean;
    }

    @Override
    public MarineLitterBatch saveMarineLitterBatch(MarineLitterBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId());
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(bean.getIdAsInt());
        Preconditions.checkNotNull((Object)catchBatchId);
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        Preconditions.checkNotNull((Object)catchBatch);
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        SortingBatch batch = this.catchBatchDao.getSortingBatchById(catchBatch, bean.getIdAsInt());
        this.marineLitterBatchToEntity(bean, batch, catchBatch);
        this.catchBatchDao.updateSortingBatch(batch, catchBatch);
        this.getCurrentSession().flush();
        return bean;
    }

    @Override
    public void deleteMarineLitterBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        Integer batchId = Integer.valueOf(id);
        this.catchBatchDao.removeWithChildren(batchId);
        this.attachmentPersistenceService.deleteAllAttachment(AttachementObjectTypeEnum.BATCH, batchId);
        this.getCurrentSession().flush();
    }

    public MarineLitterBatch entityToMarineLitterBatch(SortingBatch source, MarineLitterBatch target) {
        target.setId(source.getId().toString());
        target.setNumber(source.getIndividualCount());
        target.setWeight(source.getWeight());
        target.setComment(source.getComments());
        for (SortingMeasurement measurement : source.getSortingMeasurements()) {
            CaracteristicQualitativeValue value;
            Integer id;
            QualitativeValue qualitativeValue;
            Integer pmfmId = measurement.getPmfm().getId();
            if (this.marineLitterCategory.equals(pmfmId)) {
                qualitativeValue = measurement.getQualitativeValue();
                id = qualitativeValue.getId();
                value = this.marineLitterCategoryCaracteristicValues.get(id);
                target.setMarineLitterCategory(value);
                continue;
            }
            if (!this.marineLitterSizeCategory.equals(pmfmId)) continue;
            qualitativeValue = measurement.getQualitativeValue();
            id = qualitativeValue.getId();
            value = this.marineLitterSizeCategoryCaracteristicValues.get(id);
            target.setMarineLitterSizeCategory(value);
        }
        return target;
    }

    protected void marineLitterBatchToEntity(MarineLitterBatch source, SortingBatch target, CatchBatch catchBatch) {
        Preconditions.checkNotNull((Object)source.getFishingOperation());
        Preconditions.checkNotNull((Object)source.getFishingOperation().getId());
        Integer recorderDepartmentId = this.batchHelper.getRecorderDepartmentId();
        Collection quantificationMeasurements = target.getQuantificationMeasurements();
        Collection sortingMeasurements = target.getSortingMeasurements();
        HashSet notChangedQuantificationMeasurements = Sets.newHashSet();
        if (quantificationMeasurements != null) {
            notChangedQuantificationMeasurements.addAll(quantificationMeasurements);
        }
        HashSet notChangedSortingMeasurements = Sets.newHashSet();
        if (sortingMeasurements != null) {
            notChangedSortingMeasurements.addAll(sortingMeasurements);
        }
        if (target.getId() == null || target.getRootBatch() == null) {
            this.setBatchParents(target, catchBatch);
        }
        if (target.getRankOrder() == null) {
            short rankOrder = 1;
            if (target.getParentBatch() != null && target.getParentBatch().getChildBatchs() != null) {
                rankOrder = (short)(rankOrder + (short)target.getParentBatch().getChildBatchs().size());
            }
            target.setRankOrder(Short.valueOf(rankOrder));
        }
        target.setSubgroupCount(Float.valueOf(1.0f));
        if (source.getWeight() != null) {
            QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, source.getWeight(), true);
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (source.getMarineLitterCategory() != null) {
            SortingMeasurement measurement = this.catchBatchDao.getSortingMeasurement(target, this.marineLitterCategory, recorderDepartmentId, true);
            measurement.setQualitativeValue((QualitativeValue)this.load(QualitativeValueImpl.class, source.getMarineLitterCategory().getIdAsInt()));
            notChangedSortingMeasurements.remove(measurement);
        }
        if (source.getMarineLitterSizeCategory() != null) {
            SortingMeasurement measurement = this.catchBatchDao.getSortingMeasurement(target, this.marineLitterSizeCategory, recorderDepartmentId, true);
            measurement.setQualitativeValue((QualitativeValue)this.load(QualitativeValueImpl.class, source.getMarineLitterSizeCategory().getIdAsInt()));
            notChangedSortingMeasurements.remove(measurement);
        }
        target.setSamplingRatio(Float.valueOf(1.0f));
        target.setSamplingRatioText(null);
        target.setIndividualCount(source.getNumber());
        QualityFlagImpl qualityFlag = this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED));
        target.setQualityFlag((QualityFlag)qualityFlag);
        target.setComments(source.getComment());
        target.setExhaustiveInventory(Boolean.valueOf(true));
        if (quantificationMeasurements != null) {
            quantificationMeasurements.removeAll(notChangedQuantificationMeasurements);
        }
        if (sortingMeasurements != null) {
            sortingMeasurements.removeAll(notChangedSortingMeasurements);
        }
    }

    public void setBatchParents(SortingBatch target, CatchBatch catchBatch) {
        Preconditions.checkNotNull((Object)target);
        SortingBatch parentBatch = this.getMarineLitterParentBatch(catchBatch);
        if (parentBatch == null) {
            throw new DataIntegrityViolationException("Could not retrieve parent batch, for a given marineLitterBatch : invalid batch tree structure. Please make sure CatchBatch has been saved before to create a MarineLitterBatch.");
        }
        target.setParentBatch((Batch)parentBatch);
        target.setRootBatch(catchBatch);
    }

    protected SortingBatch getMarineLitterParentBatch(CatchBatch catchBatch) {
        SortingBatch parentBatch = this.catchBatchDao.getSortingBatch(catchBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID, "pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_MARINE_LITTER});
        return parentBatch;
    }
}

