/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.caracteristics;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.caracteristics.CaracteristicMapCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.caracteristics.CaracteristicMapEditorRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.caracteristics.CaracteristicMapEditorTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.caracteristics.CaracteristicMapEditorUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueEditor;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueRenderer;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class CaracteristicMapEditorUIHandler
extends AbstractTuttiTableUIHandler<CaracteristicMapEditorRowModel, CaracteristicMapEditorUIModel, CaracteristicMapEditorUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(CaracteristicMapEditorUIHandler.class);
    protected CaracteristicMapCellComponent.CaracteristicMapCellEditor caracteristicMapCellEditor;

    public CaracteristicMapEditorUIHandler(TuttiUI parentUi, CaracteristicMapEditorUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui, "value");
    }

    public CaracteristicMapEditorTableModel getTableModel() {
        return (CaracteristicMapEditorTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((CaracteristicMapEditorUI)this.ui).getCaracteristicMapEditorTable();
    }

    @Override
    protected boolean isRowValid(CaracteristicMapEditorRowModel row) {
        return row.getKey() != null && row.getValue() != null;
    }

    @Override
    protected void onRowModified(int rowIndex, CaracteristicMapEditorRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        super.onRowModified(rowIndex, row, propertyName, oldValue, newValue);
        this.saveSelectedRowIfNeeded();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<CaracteristicMapEditorRowModel> rowMonitor, CaracteristicMapEditorRowModel row) {
        if (row.isValid() && rowMonitor.wasModified()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Row " + (Object)((Object)row) + " was modified, will save it"));
            }
            this.saveRow(row);
        }
    }

    @Override
    public void beforeInitUI() {
        CaracteristicMapEditorUIModel model = this.createModel();
        ((CaracteristicMapEditorUI)this.getUI()).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI((TuttiUI)this.getUI());
        this.initBeanFilterableComboBox(this.getKeyCombo(), Lists.newArrayList(), null);
        ((CaracteristicMapEditorUIModel)((Object)this.getModel())).setAvailableCaracteristics(this.getDataContext().getCaracteristics());
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Caracteristic.class, "withUnit"), CaracteristicMapEditorTableModel.KEY);
        this.addColumnToModel((TableColumnModel)columnModel, new CaracteristicValueEditor(this.context), new CaracteristicValueRenderer(this.context), CaracteristicMapEditorTableModel.VALUE);
        CaracteristicMapEditorTableModel tableModel = new CaracteristicMapEditorTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((CaracteristicMapEditorUI)this.getUI()).getNewRowKey();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        ((CaracteristicMapEditorUIModel)((Object)this.getModel())).setValid(false);
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getHandler().setIndividualObservationSelectedCard("main");
    }

    @Override
    public SwingValidator<CaracteristicMapEditorUIModel> getValidator() {
        return null;
    }

    @Override
    public void cancel() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Cancel UI " + this.ui));
        }
        this.closeUI(this.ui);
    }

    protected BeanFilterableComboBox<Caracteristic> getKeyCombo() {
        return ((CaracteristicMapEditorUI)this.ui).getNewRowKey();
    }

    protected CaracteristicMapEditorUIModel createModel() {
        return new CaracteristicMapEditorUIModel();
    }

    protected CaracteristicMap getCaracteristics(IndividualObservationBatch individualObservation) {
        return individualObservation.getCaracteristics();
    }

    protected List<String> getProtocolPmfmIds(TuttiProtocol protocol) {
        return protocol.getGearUseFeaturePmfmId();
    }

    protected void saveRow(CaracteristicMapEditorRowModel row) {
        if (row.isValid()) {
            CaracteristicMap caracteristics = ((CaracteristicMapEditorUIModel)((Object)this.getModel())).getCaracteristicMap();
            Preconditions.checkNotNull((Object)caracteristics);
            caracteristics.put((Object)row.getKey(), (Object)row.getValue());
        }
    }

    public void addRow() {
        BeanFilterableComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        Caracteristic selectedItem = (Caracteristic)keyCombo.getSelectedItem();
        CaracteristicMapEditorTableModel tableModel = this.getTableModel();
        CaracteristicMapEditorRowModel row = tableModel.createNewRow();
        row.setKey(selectedItem);
        ((CaracteristicMapEditorUIModel)((Object)this.getModel())).getRows().add(row);
        int rowIndex = tableModel.getRowCount() - 1;
        tableModel.fireTableRowsInserted(rowIndex, rowIndex);
        keyCombo.getHandler().removeItem((Object)selectedItem);
        CaracteristicMapEditorUIModel model = (CaracteristicMapEditorUIModel)((Object)this.getModel());
        model.setModify(true);
        this.recomputeRowValidState(row);
    }

    public void editBatch(IndividualObservationBatchRowModel individualObservation, CaracteristicMapCellComponent.CaracteristicMapCellEditor caracteristicMapCellEditor) {
        List<String> protocolPmfmId;
        this.caracteristicMapCellEditor = caracteristicMapCellEditor;
        CaracteristicMapEditorTableModel tableModel = this.getTableModel();
        CaracteristicMapEditorUIModel model = (CaracteristicMapEditorUIModel)((Object)this.getModel());
        CaracteristicMap caracteristicMap = this.getCaracteristics(individualObservation);
        if (caracteristicMap == null) {
            caracteristicMap = new CaracteristicMap();
        }
        model.setCaracteristicMap(caracteristicMap);
        TuttiProtocol protocol = this.getDataContext().getProtocol();
        ArrayList pmfmIds = Lists.newArrayList();
        if (protocol != null && (protocolPmfmId = this.getProtocolPmfmIds(protocol)) != null) {
            pmfmIds.addAll(protocolPmfmId);
        }
        ArrayList rows = Lists.newArrayList();
        ArrayList caracteristics = Lists.newArrayList((Iterable)caracteristicMap.keySet());
        List<Caracteristic> availableCaracteristics = model.getAvailableCaracteristics();
        for (String id : pmfmIds) {
            Caracteristic caracteristic = (Caracteristic)TuttiEntities.findById(availableCaracteristics, (String)id);
            if (caracteristics.contains(caracteristic)) continue;
            caracteristics.add(caracteristic);
        }
        for (Caracteristic key : caracteristics) {
            CaracteristicMapEditorRowModel newRow = tableModel.createNewRow();
            newRow.setKey(key);
            newRow.setValue((Serializable)caracteristicMap.get((Object)key));
            rows.add(newRow);
        }
        model.setRows(rows);
        ArrayList caracteristicList = Lists.newArrayList();
        for (Caracteristic caracteristic : availableCaracteristics) {
            if (caracteristics.contains(caracteristic)) continue;
            caracteristicList.add(caracteristic);
        }
        BeanFilterableComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        keyCombo.setData((List)caracteristicList);
        keyCombo.getHandler().reset();
        model.setModify(false);
    }

    public void removeCaracteristic() {
        int rowIndex = this.getTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove caracteristic if no caracteristic selected");
        CaracteristicMapEditorRowModel row = (CaracteristicMapEditorRowModel)((Object)this.getTableModel().getEntry(rowIndex));
        CaracteristicMap caracteristicMap = ((CaracteristicMapEditorUIModel)((Object)this.getModel())).getCaracteristicMap();
        if (caracteristicMap != null) {
            caracteristicMap.remove((Object)row.getKey());
        }
        BeanFilterableComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        keyCombo.addItem((Object)row.getKey());
        keyCombo.getHandler().reset();
        ((CaracteristicMapEditorUIModel)((Object)this.getModel())).getRows().remove(rowIndex);
        this.getTableModel().fireTableRowsDeleted(rowIndex, rowIndex);
        ((CaracteristicMapEditorUIModel)((Object)this.getModel())).removeRowInError(row);
    }

    public void save() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Save UI " + this.ui));
        }
        this.caracteristicMapCellEditor.validateEdition((CaracteristicMapEditorUIModel)((Object)this.getModel()));
        this.closeUI(this.ui);
    }
}

