/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.RemoveBenthosSubBatchAction;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import java.util.HashSet;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;

public class RemoveBenthosBatchAction
extends AbstractTuttiAction<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {
    private static final Log log = LogFactory.getLog(RemoveBenthosBatchAction.class);
    protected RemoveBenthosSubBatchAction removeSpeciesSubBatchAction;

    public RemoveBenthosBatchAction(BenthosBatchUIHandler handler) {
        super(handler, false);
        this.removeSpeciesSubBatchAction = new RemoveBenthosSubBatchAction(handler);
    }

    @Override
    protected void doAction() throws Exception {
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        JXTable table = ((BenthosBatchUIHandler)this.handler).getTable();
        int rowIndex = table.getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove batch if no batch selected");
        BenthosBatchTableModel tableModel = ((BenthosBatchUIHandler)this.handler).getTableModel();
        BenthosBatchRowModel selectedBatch = (BenthosBatchRowModel)tableModel.getEntry(rowIndex);
        Preconditions.checkState((!TuttiEntities.isNew((TuttiEntity)selectedBatch) ? 1 : 0) != 0, (Object)"Can't remove batch if batch is not persisted");
        if (!selectedBatch.isBatchRoot()) {
            BenthosBatchRowModel parentBatch = selectedBatch.getParentBatch();
            int parentIndex = tableModel.getRowIndex(parentBatch);
            table.setRowSelectionInterval(parentIndex, parentIndex);
            RemoveBenthosBatchAction.runAction(this.removeSpeciesSubBatchAction);
        } else {
            persistenceService.deleteBenthosBatch(selectedBatch.getId());
            ((BenthosBatchUIHandler)this.handler).removeFromSpeciesUsed(selectedBatch);
            HashSet rowToRemove = Sets.newHashSet((Object[])new BenthosBatchRowModel[]{selectedBatch});
            ((BenthosBatchUIHandler)this.handler).collectChildren(selectedBatch, rowToRemove);
            table.clearSelection();
            ((BenthosBatchUIModel)this.getModel()).getRows().removeAll(rowToRemove);
            tableModel.fireTableDataChanged();
            if (!((BenthosBatchUIModel)this.getModel()).getRows().isEmpty()) {
                AbstractSelectTableAction.doSelectCell((JTable)table, 0, 0);
            }
            if (table.isEditing()) {
                table.getCellEditor().stopCellEditing();
            }
        }
    }
}

