/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.config;

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.config.SampleOrderEditorUI;
import java.awt.Point;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.SwingUtil;
import org.nuiton.i18n.I18n;

public class SampleOrderButton
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    protected final SampleOrderEditorUI popup;
    protected Point popupPosition = null;
    protected boolean popupMoving;

    public SampleOrderButton(TuttiUIContext context, List<Caracteristic> model) {
        this.setIcon(SwingUtil.createActionIcon((String)"sampleOrder"));
        this.setToolTipText(I18n._((String)"tutti.config.action.sampleOrder.tip", (Object[])new Object[0]));
        this.popup = new SampleOrderEditorUI(context);
        this.popup.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                SampleOrderButton.this.setSelected(true);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                SampleOrderButton.this.setSelected(false);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                SampleOrderButton.this.setSelected(false);
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SampleOrderButton.this.isSelected()) {
                    if (!SampleOrderButton.this.popup.isVisible()) {
                        SampleOrderButton.this.popup.openEditor(SampleOrderButton.this);
                    }
                } else {
                    SampleOrderButton.this.popup.closeEditor();
                }
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ancestorMoved(HierarchyEvent e) {
                if (SampleOrderButton.this.popup.isShowing()) {
                    Point point = new Point(SampleOrderButton.this.getLocationOnScreen());
                    point.translate(-SampleOrderButton.this.popup.getWidth() + SampleOrderButton.this.getWidth(), SampleOrderButton.this.getHeight());
                    SampleOrderButton.this.popupMoving = true;
                    try {
                        SampleOrderButton.this.popup.setLocation(point);
                    }
                    finally {
                        SampleOrderButton.this.popupMoving = false;
                    }
                }
            }
        });
        this.setBean(model);
    }

    public void init() {
        this.popup.getHandler().init();
    }

    public void init(List<Caracteristic> model) {
        this.setBean(model);
        this.init();
    }

    public void onCloseUI() {
        this.setSelected(false);
    }

    public List<Caracteristic> getBean() {
        return this.popup.getListModel().toList();
    }

    protected void setBean(List<Caracteristic> model) {
        this.popup.setBean(model);
        this.init();
    }
}

