/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.yamlbeans;

import com.esotericsoftware.yamlbeans.Beans;
import com.esotericsoftware.yamlbeans.DeferredConstruction;
import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.parser.AliasEvent;
import com.esotericsoftware.yamlbeans.parser.CollectionStartEvent;
import com.esotericsoftware.yamlbeans.parser.Event;
import com.esotericsoftware.yamlbeans.parser.EventType;
import com.esotericsoftware.yamlbeans.parser.Parser;
import com.esotericsoftware.yamlbeans.parser.ScalarEvent;
import com.esotericsoftware.yamlbeans.scalar.ScalarSerializer;
import com.esotericsoftware.yamlbeans.tokenizer.Tokenizer;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlReader {
    private final YamlConfig config;
    Parser parser;
    private final Map<String, Object> anchors = new HashMap<String, Object>();

    public YamlReader(Reader reader) {
        this(reader, new YamlConfig());
    }

    public YamlReader(Reader reader, YamlConfig config) {
        this.config = config;
        this.parser = new Parser(reader, config.readConfig.defaultVersion);
    }

    public YamlReader(String yaml) {
        this(new StringReader(yaml));
    }

    public YamlReader(String yaml, YamlConfig config) {
        this(new StringReader(yaml), config);
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    public void close() throws IOException {
        this.parser.close();
        this.anchors.clear();
    }

    public Object read() throws YamlException {
        return this.read(null);
    }

    public <T> T read(Class<T> type) throws YamlException {
        return this.read(type, null);
    }

    public <T> T read(Class<T> type, Class elementType) throws YamlException {
        try {
            Event event;
            do {
                if ((event = this.parser.getNextEvent()) == null) {
                    return null;
                }
                if (event.type != EventType.STREAM_END) continue;
                return null;
            } while (event.type != EventType.DOCUMENT_START);
            return (T)this.readValue(type, elementType, null);
        }
        catch (Parser.ParserException ex) {
            throw new YamlException("Error parsing YAML.", ex);
        }
        catch (Tokenizer.TokenizerException ex) {
            throw new YamlException("Error tokenizing YAML.", ex);
        }
    }

    protected Object readValue(Class type, Class elementType, Class defaultType) throws YamlException, Parser.ParserException, Tokenizer.TokenizerException {
        String tag = null;
        String anchor = null;
        Event event = this.parser.peekNextEvent();
        switch (event.type) {
            case ALIAS: {
                this.parser.getNextEvent();
                anchor = ((AliasEvent)event).anchor;
                Object value = this.anchors.get(anchor);
                if (value == null) {
                    throw new YamlReaderException("Unknown anchor: " + anchor);
                }
                return value;
            }
            case MAPPING_START: 
            case SEQUENCE_START: {
                tag = ((CollectionStartEvent)event).tag;
                anchor = ((CollectionStartEvent)event).anchor;
                break;
            }
            case SCALAR: {
                tag = ((ScalarEvent)event).tag;
                anchor = ((ScalarEvent)event).anchor;
            }
        }
        if (tag != null) {
            type = this.config.tagToClass.get(tag);
            if (type == null) {
                try {
                    if (this.config.readConfig.classLoader != null) {
                        type = Class.forName(tag, true, this.config.readConfig.classLoader);
                    }
                    type = Class.forName(tag);
                }
                catch (ClassNotFoundException ex) {
                    throw new YamlReaderException("Unable to find class specified by tag: " + tag);
                }
            }
        } else if (defaultType != null) {
            type = defaultType;
        }
        return this.readValueInternal(type, elementType, anchor);
    }

    private Object readValueInternal(Class type, Class elementType, String anchor) throws YamlException, Parser.ParserException, Tokenizer.TokenizerException {
        Event event;
        if (type == null || type == Object.class) {
            event = this.parser.peekNextEvent();
            switch (event.type) {
                case MAPPING_START: {
                    type = HashMap.class;
                    break;
                }
                case SCALAR: {
                    type = String.class;
                    break;
                }
                case SEQUENCE_START: {
                    type = ArrayList.class;
                    break;
                }
                default: {
                    throw new YamlReaderException("Expected scalar, sequence, or mapping but found: " + (Object)((Object)event.type));
                }
            }
        }
        if (type == String.class) {
            event = this.parser.getNextEvent();
            if (event.type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for String type but found: " + (Object)((Object)event.type));
            }
            String value = ((ScalarEvent)event).value;
            if (anchor != null) {
                this.anchors.put(anchor, value);
            }
            return value;
        }
        if (Beans.isScalar(type)) {
            event = this.parser.getNextEvent();
            if (event.type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for primitive type '" + type.getClass() + "' but found: " + (Object)((Object)event.type));
            }
            String value = ((ScalarEvent)event).value;
            try {
                Object convertedValue;
                if (type == String.class) {
                    convertedValue = value;
                } else if (type == Integer.TYPE) {
                    convertedValue = Integer.valueOf(value);
                } else if (type == Integer.class) {
                    convertedValue = value.length() == 0 ? null : Integer.valueOf(value);
                } else if (type == Boolean.TYPE) {
                    convertedValue = Boolean.valueOf(value);
                } else if (type == Boolean.class) {
                    convertedValue = value.length() == 0 ? null : Boolean.valueOf(value);
                } else if (type == Float.TYPE) {
                    convertedValue = Float.valueOf(value);
                } else if (type == Float.class) {
                    convertedValue = value.length() == 0 ? null : Float.valueOf(value);
                } else if (type == Double.TYPE) {
                    convertedValue = Double.valueOf(value);
                } else if (type == Double.class) {
                    convertedValue = value.length() == 0 ? null : Double.valueOf(value);
                } else if (type == Long.TYPE) {
                    convertedValue = Long.valueOf(value);
                } else if (type == Long.class) {
                    convertedValue = value.length() == 0 ? null : Long.valueOf(value);
                } else if (type == Short.TYPE) {
                    convertedValue = Short.valueOf(value);
                } else if (type == Short.class) {
                    convertedValue = value.length() == 0 ? null : Short.valueOf(value);
                } else if (type == Character.TYPE) {
                    convertedValue = Character.valueOf(value.charAt(0));
                } else if (type == Character.class) {
                    convertedValue = value.length() == 0 ? null : Character.valueOf(value.charAt(0));
                } else if (type == Byte.TYPE) {
                    convertedValue = Byte.valueOf(value);
                } else if (type == Byte.class) {
                    convertedValue = value.length() == 0 ? null : Byte.valueOf(value);
                } else {
                    throw new YamlException("Unknown field type.");
                }
                if (anchor != null) {
                    this.anchors.put(anchor, convertedValue);
                }
                return convertedValue;
            }
            catch (Exception ex) {
                throw new YamlReaderException("Unable to convert value to required type \"" + type + "\": " + value, ex);
            }
        }
        if (Enum.class.isAssignableFrom(type)) {
            event = this.parser.getNextEvent();
            if (event.type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for enum type but found: " + (Object)((Object)event.type));
            }
            String enumValueName = ((ScalarEvent)event).value;
            if (enumValueName.length() == 0) {
                return null;
            }
            try {
                return Enum.valueOf(type, enumValueName);
            }
            catch (Exception ex) {
                throw new YamlReaderException("Unable to find enum value '" + enumValueName + "' for enum class: " + type.getName());
            }
        }
        for (Map.Entry<Class, ScalarSerializer> entry : this.config.scalarSerializers.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            ScalarSerializer serializer = entry.getValue();
            Event event2 = this.parser.getNextEvent();
            if (event2.type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for type '" + type + "' to be deserialized by scalar serializer '" + serializer.getClass().getName() + "' but found: " + (Object)((Object)event2.type));
            }
            Object value = serializer.read(((ScalarEvent)event2).value);
            if (anchor != null) {
                this.anchors.put(anchor, value);
            }
            return value;
        }
        event = this.parser.peekNextEvent();
        switch (event.type) {
            case MAPPING_START: {
                Object object;
                event = this.parser.getNextEvent();
                try {
                    object = this.createObject(type);
                }
                catch (InvocationTargetException ex) {
                    throw new YamlReaderException("Error creating object.", ex);
                }
                if (anchor != null) {
                    this.anchors.put(anchor, object);
                }
                while (true) {
                    if (this.parser.peekNextEvent().type == EventType.MAPPING_END) break;
                    Object key = this.readValue(null, null, null);
                    boolean isExplicitKey = key instanceof Map;
                    Object value = null;
                    if (isExplicitKey) {
                        Map.Entry entry = ((Map)key).entrySet().iterator().next();
                        key = entry.getKey();
                        value = entry.getValue();
                    }
                    if (object instanceof Map) {
                        if (!isExplicitKey) {
                            value = this.readValue(elementType, null, null);
                        }
                        ((Map)object).put(key, value);
                        continue;
                    }
                    try {
                        Beans.Property property = Beans.getProperty(type, (String)key, this.config.beanProperties, this.config.privateFields, this.config);
                        if (property == null) {
                            throw new YamlReaderException("Unable to find property '" + key + "' on class: " + type.getName());
                        }
                        Class propertyElementType = this.config.propertyToElementType.get(property);
                        Class propertyDefaultType = this.config.propertyToDefaultType.get(property);
                        if (!isExplicitKey) {
                            value = this.readValue(property.getType(), propertyElementType, propertyDefaultType);
                        }
                        property.set(object, value);
                    }
                    catch (Exception exception) {
                        if (exception instanceof YamlReaderException) {
                            throw (YamlReaderException)exception;
                        }
                        throw new YamlReaderException("Error setting property '" + key + "' on class: " + type.getName(), exception);
                    }
                }
                this.parser.getNextEvent();
                if (object instanceof DeferredConstruction) {
                    try {
                        object = ((DeferredConstruction)object).construct();
                        if (anchor != null) {
                            this.anchors.put(anchor, object);
                        }
                    }
                    catch (InvocationTargetException ex) {
                        throw new YamlReaderException("Error creating object.", ex);
                    }
                }
                return object;
            }
            case SEQUENCE_START: {
                Collection<Object> collection;
                event = this.parser.getNextEvent();
                if (Collection.class.isAssignableFrom(type)) {
                    try {
                        collection = (Collection)Beans.createObject(type, this.config.privateConstructors);
                    }
                    catch (InvocationTargetException ex) {
                        throw new YamlReaderException("Error creating object.", ex);
                    }
                } else if (type.isArray()) {
                    collection = new ArrayList();
                    elementType = type.getComponentType();
                } else {
                    throw new YamlReaderException("A sequence is not a valid value for the type: " + type.getName());
                }
                if (!type.isArray() && anchor != null) {
                    this.anchors.put(anchor, collection);
                }
                while (true) {
                    event = this.parser.peekNextEvent();
                    if (event.type == EventType.SEQUENCE_END) break;
                    collection.add(this.readValue(elementType, null, null));
                }
                this.parser.getNextEvent();
                if (!type.isArray()) {
                    return collection;
                }
                Object array = Array.newInstance(elementType, collection.size());
                int i = 0;
                for (Object e : collection) {
                    Array.set(array, i++, e);
                }
                if (anchor != null) {
                    this.anchors.put(anchor, array);
                }
                return array;
            }
            case SCALAR: {
                if (((ScalarEvent)event).value.length() != 0) break;
                event = this.parser.getNextEvent();
                return null;
            }
        }
        throw new YamlReaderException("Expected data for a " + type.getName() + " field but found: " + (Object)((Object)event.type));
    }

    protected Object createObject(Class type) throws InvocationTargetException {
        DeferredConstruction deferredConstruction = Beans.getDeferredConstruction(type, this.config);
        if (deferredConstruction != null) {
            return deferredConstruction;
        }
        return Beans.createObject(type, this.config.privateConstructors);
    }

    public static void main(String[] args) throws Exception {
        YamlReader reader = new YamlReader(new FileReader("test/test.yml"));
        System.out.println(reader.read());
    }

    public class YamlReaderException
    extends YamlException {
        public YamlReaderException(String message, Throwable cause) {
            super("Line " + YamlReader.this.parser.getLineNumber() + ", column " + YamlReader.this.parser.getColumn() + ": " + message, cause);
        }

        public YamlReaderException(String message) {
            this(message, null);
        }
    }
}

