/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIModel;
import fr.ifremer.tutti.ui.swing.content.cruise.VesselTypeEnum;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.CloseableUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditCruiseUIHandler
extends AbstractTuttiUIHandler<EditCruiseUIModel, EditCruiseUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(EditCruiseUIHandler.class);
    private final PersistenceService persistenceService;

    public static String getTitle(boolean exist) {
        String result = exist ? I18n._((String)"tutti.editCruise.title.edit.cruise", (Object[])new Object[0]) : I18n._((String)"tutti.editCruise.title.create.cruise", (Object[])new Object[0]);
        return result;
    }

    public EditCruiseUIHandler(TuttiUI parentUi, EditCruiseUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui);
        this.persistenceService = this.context.getPersistenceService();
    }

    @Override
    public void beforeInitUI() {
        this.getDataContext().resetValidationDataContext();
        EditCruiseUIModel model = new EditCruiseUIModel();
        if (this.context.isCruiseFilled()) {
            Cruise cruise = this.getDataContext().getCruise();
            model.fromBean(cruise);
            List attachments = this.persistenceService.getAllAttachments(Integer.valueOf(model.getObjectId()));
            model.addAllAttachment(attachments);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit cruise: " + cruise.getId()));
            }
        } else {
            Program program = this.getDataContext().getProgram();
            model.setProgram(program);
            model.setMultirigNumber(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will create a new cruise from program: " + program));
            }
        }
        this.listModelIsModify(model);
        ((EditCruiseUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        List users = this.persistenceService.getAllPerson();
        EditCruiseUIModel model = (EditCruiseUIModel)this.getModel();
        List scientificVesselList = this.getDataContext().getScientificVessels();
        List fishingVesselList = this.getDataContext().getFishingVessels();
        ArrayList allVesselList = Lists.newArrayList();
        allVesselList.addAll(scientificVesselList);
        allVesselList.addAll(fishingVesselList);
        List scientificGearList = this.getDataContext().getScientificGears();
        List fishingGearList = this.getDataContext().getFishingGears();
        ArrayList allGearList = Lists.newArrayList();
        allGearList.addAll(scientificGearList);
        allGearList.addAll(fishingGearList);
        model.addPropertyChangeListener("vesselType", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                VesselTypeEnum vesselType = (VesselTypeEnum)((Object)evt.getNewValue());
                Predicate<Gear> gearPredicate = null;
                ArrayList allVesselList = Lists.newArrayList();
                switch (vesselType) {
                    case FISHING: {
                        gearPredicate = TuttiEntities.IS_FISHING_GEAR;
                        allVesselList.addAll(EditCruiseUIHandler.this.getDataContext().getFishingVessels());
                        break;
                    }
                    case SCIENTIFIC: {
                        gearPredicate = TuttiEntities.IS_SCIENTIFIC_GEAR;
                        allVesselList.addAll(EditCruiseUIHandler.this.getDataContext().getScientificVessels());
                        break;
                    }
                    default: {
                        allVesselList.addAll(EditCruiseUIHandler.this.getDataContext().getScientificVessels());
                        allVesselList.addAll(EditCruiseUIHandler.this.getDataContext().getFishingVessels());
                    }
                }
                ((EditCruiseUI)EditCruiseUIHandler.this.ui).getGearList().getHandler().clearFilters();
                ((EditCruiseUI)EditCruiseUIHandler.this.ui).getVesselComboBox().setData(null);
                ((EditCruiseUI)EditCruiseUIHandler.this.ui).getVesselComboBox().setData((List)allVesselList);
                if (gearPredicate != null) {
                    ((EditCruiseUI)EditCruiseUIHandler.this.ui).getGearList().getHandler().addFilter(gearPredicate);
                }
            }
        });
        this.initBeanFilterableComboBox(((EditCruiseUI)this.ui).getProgramComboBox(), this.persistenceService.getAllProgram(), model.getProgram(), "onlyName");
        this.initBeanFilterableComboBox(((EditCruiseUI)this.ui).getDepartureLocationComboBox(), this.persistenceService.getAllHarbour(), model.getDepartureLocation());
        this.initBeanFilterableComboBox(((EditCruiseUI)this.ui).getReturnLocationComboBox(), this.persistenceService.getAllHarbour(), model.getReturnLocation());
        this.initBeanFilterableComboBox(((EditCruiseUI)this.ui).getVesselComboBox(), allVesselList, model.getVessel());
        this.initBeanList(((EditCruiseUI)this.ui).getGearList(), allGearList, model.getGear());
        this.initBeanList(((EditCruiseUI)this.ui).getHeadOfMissionList(), users, model.getHeadOfMission());
        this.initBeanList(((EditCruiseUI)this.ui).getHeadOfSortRoomList(), users, model.getHeadOfSortRoom());
        SwingValidator<EditCruiseUIModel> validator = ((EditCruiseUI)this.ui).getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        model.setVesselType(VesselTypeEnum.SCIENTIFIC);
        model.setModify(model.isCreate());
        this.registerValidators(validator);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((EditCruiseUI)this.getUI()).getProgramComboBox();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
        ((EditCruiseUI)this.ui).getAttachmentsButton().onCloseUI();
    }

    @Override
    public boolean quitUI() {
        boolean result = this.quitScreen(((EditCruiseUIModel)this.getModel()).isValid(), ((EditCruiseUIModel)this.getModel()).isModify(), I18n._((String)"tutti.editCruise.askCancelEditBeforeLeaving.cancelSaveCruise", (Object[])new Object[0]), I18n._((String)"tutti.editCruise.askSaveBeforeLeaving.saveCruise", (Object[])new Object[0]), ((EditCruiseUI)this.ui).getSaveButton().getAction());
        return result;
    }

    @Override
    public SwingValidator<EditCruiseUIModel> getValidator() {
        return ((EditCruiseUI)this.ui).getValidator();
    }

    public void generateCampaignName() {
        EditCruiseUIModel model = (EditCruiseUIModel)this.getModel();
        String name = model.getGeneratedCampaignName();
        model.setName(name);
    }
}

