/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.CloseApplicationAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.updater.ApplicationUpdater;
import org.nuiton.util.updater.ApplicationUpdaterCallback;
import org.nuiton.util.updater.DownloadMonitor;

public class UpdateApplicationAction
extends AbstractTuttiAction<TuttiUIContext, MainUI, MainUIHandler> {
    private static final Log log = LogFactory.getLog(UpdateApplicationAction.class);
    public static final TuttiApplicationUpdaterCallBack.UpdateType[] ALL_APPLICATION_TYPES = new TuttiApplicationUpdaterCallBack.UpdateType[]{TuttiApplicationUpdaterCallBack.UpdateType.JRE, TuttiApplicationUpdaterCallBack.UpdateType.I18N, TuttiApplicationUpdaterCallBack.UpdateType.TUTTI, TuttiApplicationUpdaterCallBack.UpdateType.HELP};
    protected TuttiApplicationUpdaterCallBack.UpdateType[] types;
    protected boolean reload;

    public UpdateApplicationAction(MainUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n._((String)"tutti.main.action.updateApplication.tip", (Object[])new Object[0]));
        this.types = ALL_APPLICATION_TYPES;
    }

    @Override
    protected void releaseAction() {
        super.releaseAction();
        this.types = ALL_APPLICATION_TYPES;
    }

    @Override
    protected void doAction() throws Exception {
        this.reload = false;
        TuttiUIContext context = this.getContext();
        TuttiApplicationConfig config = context.getConfig();
        File current = config.getTuttiBasedir();
        if (current == null || !current.exists()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No application base directory defined, skip updates.");
            }
        } else {
            String url = config.getUpdateUrl();
            File dest = new File(config.getTuttiBasedir(), "NEW");
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Try to update jre, i18N, help or tutti (current application location: %s), using update url: %s", current, url));
            }
            ProgressionModel progressionModel = new ProgressionModel();
            context.getActionUI().getModel().setProgressionModel(progressionModel);
            progressionModel.setMessage("Recherche de mises \u00e0 jour");
            TuttiApplicationUpdaterCallBack callback = new TuttiApplicationUpdaterCallBack(this, progressionModel);
            callback.setTypes(this.types);
            ApplicationUpdater up = new ApplicationUpdater();
            up.update(url, current, dest, false, (ApplicationUpdaterCallback)callback, (DownloadMonitor)progressionModel);
            if (callback.isApplicationUpdated()) {
                this.reload = true;
            } else {
                this.sendMessage("Aucune mise \u00e0 jour de l'application d\u00e9tect\u00e9e.");
            }
        }
    }

    public void setTypes(TuttiApplicationUpdaterCallBack.UpdateType ... types) {
        this.types = types;
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        if (this.reload) {
            block3: {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)"Could not wait 1 second...", (Throwable)e);
                }
            }
            ((MainUIHandler)this.getHandler()).showSuccessMessage("Red\u00e9marrage de Tutti n\u00e9cessaire...", "La mise \u00e0 jour n\u00e9cessite le r\u00e9d\u00e9marrage du Tutti.\nL'application va se fermer puis se r\u00e9ouvrir automatiquement.");
            CloseApplicationAction action = TuttiActionHelper.createLogicAction(this.getHandler(), CloseApplicationAction.class);
            action.setExitCode(88);
            TuttiActionHelper.runAction(action);
        }
    }

    public boolean isReload() {
        return this.reload;
    }
}

