/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.ehcache.transaction.xa.PreparedCommand;
import net.sf.ehcache.transaction.xa.PreparedCommandImpl;
import net.sf.ehcache.transaction.xa.PreparedContext;
import net.sf.ehcache.transaction.xa.VersionAwareCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedContextImpl
implements PreparedContext {
    private final List<PreparedCommand> commands = new ArrayList<PreparedCommand>();
    private volatile boolean rolledBack;
    private volatile boolean commited;

    @Override
    public void addCommand(VersionAwareCommand command) {
        this.commands.add(new PreparedCommandImpl(command.getKey(), command.isWriteCommand()));
    }

    @Override
    public List<PreparedCommand> getPreparedCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    @Override
    public Object[] getUpdatedKeys() {
        ArrayList<Object> keys = new ArrayList<Object>(this.getPreparedCommands().size());
        for (PreparedCommand command : this.getPreparedCommands()) {
            Object key = command.getKey();
            if (key == null) continue;
            keys.add(key);
        }
        return keys.toArray(new Object[keys.size()]);
    }

    @Override
    public boolean isRolledBack() {
        return this.rolledBack;
    }

    @Override
    public boolean isCommitted() {
        return this.commited;
    }

    @Override
    public void setRolledBack(boolean rolledBack) {
        if (this.commited && rolledBack) {
            throw new IllegalStateException("Context was marked as commited already!");
        }
        this.rolledBack = rolledBack;
    }

    @Override
    public void setCommitted(boolean commited) {
        if (this.rolledBack && commited) {
            throw new IllegalStateException("Context was marked as rolled back already!");
        }
        this.commited = commited;
    }
}

