/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonName;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevel;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevelDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevelImpl;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class TaxonomicLevelDaoBase
extends HibernateDaoSupport
implements TaxonomicLevelDao {
    @Override
    public Object load(int transform, String code) {
        if (code == null) {
            throw new IllegalArgumentException("TaxonomicLevel.load - 'code' can not be null");
        }
        String entityPk = code;
        Object entity = this.getHibernateTemplate().get(TaxonomicLevelImpl.class, (Serializable)((Object)entityPk));
        return this.transformEntity(transform, (TaxonomicLevel)entity);
    }

    @Override
    public TaxonomicLevel load(String code) {
        return (TaxonomicLevel)this.load(0, code);
    }

    @Override
    public Collection<TaxonomicLevel> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(TaxonomicLevelImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public TaxonomicLevel create(TaxonomicLevel taxonomicLevel) {
        return (TaxonomicLevel)this.create(0, taxonomicLevel);
    }

    @Override
    public Object create(int transform, TaxonomicLevel taxonomicLevel) {
        if (taxonomicLevel == null) {
            throw new IllegalArgumentException("TaxonomicLevel.create - 'taxonomicLevel' can not be null");
        }
        this.getHibernateTemplate().save((Object)taxonomicLevel);
        return this.transformEntity(transform, taxonomicLevel);
    }

    @Override
    public Collection<TaxonomicLevel> create(Collection<TaxonomicLevel> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<TaxonomicLevel> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonomicLevel.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TaxonomicLevelDaoBase.this.create(transform, (TaxonomicLevel)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public TaxonomicLevel create(String code, Integer rank, String name, String label, String comments, Date creationDate, Timestamp updateDate, Status status, Collection<TaxonName> taxonNames) {
        return (TaxonomicLevel)this.create(0, code, rank, name, label, comments, creationDate, updateDate, status, taxonNames);
    }

    @Override
    public Object create(int transform, String code, Integer rank, String name, String label, String comments, Date creationDate, Timestamp updateDate, Status status, Collection<TaxonName> taxonNames) {
        TaxonomicLevelImpl entity = new TaxonomicLevelImpl();
        entity.setCode(code);
        entity.setRank(rank);
        entity.setName(name);
        entity.setLabel(label);
        entity.setComments(comments);
        entity.setCreationDate(creationDate);
        entity.setUpdateDate(updateDate);
        entity.setStatus(status);
        entity.setTaxonNames(taxonNames);
        return this.create(transform, entity);
    }

    @Override
    public TaxonomicLevel create(String code, Date creationDate, String name, Integer rank, Status status) {
        return (TaxonomicLevel)this.create(0, code, creationDate, name, rank, status);
    }

    @Override
    public Object create(int transform, String code, Date creationDate, String name, Integer rank, Status status) {
        TaxonomicLevelImpl entity = new TaxonomicLevelImpl();
        entity.setCode(code);
        entity.setCreationDate(creationDate);
        entity.setName(name);
        entity.setRank(rank);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(TaxonomicLevel taxonomicLevel) {
        if (taxonomicLevel == null) {
            throw new IllegalArgumentException("TaxonomicLevel.update - 'taxonomicLevel' can not be null");
        }
        this.getHibernateTemplate().update((Object)taxonomicLevel);
    }

    @Override
    public void update(final Collection<TaxonomicLevel> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonomicLevel.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TaxonomicLevelDaoBase.this.update((TaxonomicLevel)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(TaxonomicLevel taxonomicLevel) {
        if (taxonomicLevel == null) {
            throw new IllegalArgumentException("TaxonomicLevel.remove - 'taxonomicLevel' can not be null");
        }
        this.getHibernateTemplate().delete((Object)taxonomicLevel);
    }

    @Override
    public void remove(String code) {
        if (code == null) {
            throw new IllegalArgumentException("TaxonomicLevel.remove - 'code' can not be null");
        }
        String entityPk = code;
        TaxonomicLevel entity = this.load(code);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<TaxonomicLevel> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonomicLevel.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, TaxonomicLevel entity) {
        TaxonomicLevel target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected TaxonomicLevel toEntity(Object[] row) {
        TaxonomicLevel target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof TaxonomicLevel)) continue;
                target = (TaxonomicLevel)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TaxonomicLevelImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TaxonomicLevelImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<TaxonomicLevel> search(Search search) {
        return this.search(0, search);
    }
}

