/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.taxon.Citation;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonName;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameHistory;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevel;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class TaxonNameDaoBase
extends HibernateDaoSupport
implements TaxonNameDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("TaxonName.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(TaxonNameImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (TaxonName)entity);
    }

    @Override
    public TaxonName load(Integer id) {
        return (TaxonName)this.load(0, id);
    }

    @Override
    public Collection<TaxonName> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(TaxonNameImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public TaxonName create(TaxonName taxonName) {
        return (TaxonName)this.create(0, taxonName);
    }

    @Override
    public Object create(int transform, TaxonName taxonName) {
        if (taxonName == null) {
            throw new IllegalArgumentException("TaxonName.create - 'taxonName' can not be null");
        }
        this.getHibernateTemplate().save((Object)taxonName);
        return this.transformEntity(transform, taxonName);
    }

    @Override
    public Collection<TaxonName> create(Collection<TaxonName> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<TaxonName> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonName.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TaxonNameDaoBase.this.create(transform, (TaxonName)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public TaxonName create(String name, String completeName, Boolean isNaming, Boolean isReferent, Integer upperRank, Boolean isVirtual, Boolean isObsolete, Boolean isTemporary, Date startDate, Date endDate, String comments, Date creationDate, Timestamp updateDate, Citation citation, ReferenceTaxon referenceTaxon, Collection<TaxonNameHistory> taxonNamehistory, Collection<TaxonNameHistory> parentTaxonNameHistory, Collection<TaxonName> childTaxonNames, TaxonName parentTaxonName, TaxonomicLevel taxonomicLevel) {
        return (TaxonName)this.create(0, name, completeName, isNaming, isReferent, upperRank, isVirtual, isObsolete, isTemporary, startDate, endDate, comments, creationDate, updateDate, citation, referenceTaxon, taxonNamehistory, parentTaxonNameHistory, childTaxonNames, parentTaxonName, taxonomicLevel);
    }

    @Override
    public Object create(int transform, String name, String completeName, Boolean isNaming, Boolean isReferent, Integer upperRank, Boolean isVirtual, Boolean isObsolete, Boolean isTemporary, Date startDate, Date endDate, String comments, Date creationDate, Timestamp updateDate, Citation citation, ReferenceTaxon referenceTaxon, Collection<TaxonNameHistory> taxonNamehistory, Collection<TaxonNameHistory> parentTaxonNameHistory, Collection<TaxonName> childTaxonNames, TaxonName parentTaxonName, TaxonomicLevel taxonomicLevel) {
        TaxonNameImpl entity = new TaxonNameImpl();
        entity.setName(name);
        entity.setCompleteName(completeName);
        entity.setIsNaming(isNaming);
        entity.setIsReferent(isReferent);
        entity.setUpperRank(upperRank);
        entity.setIsVirtual(isVirtual);
        entity.setIsObsolete(isObsolete);
        entity.setIsTemporary(isTemporary);
        entity.setStartDate(startDate);
        entity.setEndDate(endDate);
        entity.setComments(comments);
        entity.setCreationDate(creationDate);
        entity.setUpdateDate(updateDate);
        entity.setCitation(citation);
        entity.setReferenceTaxon(referenceTaxon);
        entity.setTaxonNamehistory(taxonNamehistory);
        entity.setParentTaxonNameHistory(parentTaxonNameHistory);
        entity.setChildTaxonNames(childTaxonNames);
        entity.setParentTaxonName(parentTaxonName);
        entity.setTaxonomicLevel(taxonomicLevel);
        return this.create(transform, entity);
    }

    @Override
    public TaxonName create(Date creationDate, Boolean isNaming, Boolean isObsolete, Boolean isReferent, Boolean isTemporary, Boolean isVirtual, String name, ReferenceTaxon referenceTaxon, Date startDate, TaxonomicLevel taxonomicLevel, Integer upperRank) {
        return (TaxonName)this.create(0, creationDate, isNaming, isObsolete, isReferent, isTemporary, isVirtual, name, referenceTaxon, startDate, taxonomicLevel, upperRank);
    }

    @Override
    public Object create(int transform, Date creationDate, Boolean isNaming, Boolean isObsolete, Boolean isReferent, Boolean isTemporary, Boolean isVirtual, String name, ReferenceTaxon referenceTaxon, Date startDate, TaxonomicLevel taxonomicLevel, Integer upperRank) {
        TaxonNameImpl entity = new TaxonNameImpl();
        entity.setCreationDate(creationDate);
        entity.setIsNaming(isNaming);
        entity.setIsObsolete(isObsolete);
        entity.setIsReferent(isReferent);
        entity.setIsTemporary(isTemporary);
        entity.setIsVirtual(isVirtual);
        entity.setName(name);
        entity.setReferenceTaxon(referenceTaxon);
        entity.setStartDate(startDate);
        entity.setTaxonomicLevel(taxonomicLevel);
        entity.setUpperRank(upperRank);
        return this.create(transform, entity);
    }

    @Override
    public void update(TaxonName taxonName) {
        if (taxonName == null) {
            throw new IllegalArgumentException("TaxonName.update - 'taxonName' can not be null");
        }
        this.getHibernateTemplate().update((Object)taxonName);
    }

    @Override
    public void update(final Collection<TaxonName> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonName.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TaxonNameDaoBase.this.update((TaxonName)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(TaxonName taxonName) {
        if (taxonName == null) {
            throw new IllegalArgumentException("TaxonName.remove - 'taxonName' can not be null");
        }
        this.getHibernateTemplate().delete((Object)taxonName);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("TaxonName.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        TaxonName entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<TaxonName> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonName.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, TaxonName entity) {
        TaxonName target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected TaxonName toEntity(Object[] row) {
        TaxonName target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof TaxonName)) continue;
                target = (TaxonName)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TaxonNameImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TaxonNameImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<TaxonName> search(Search search) {
        return this.search(0, search);
    }
}

