/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.location;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.location.LocationArea;
import fr.ifremer.adagio.core.dao.referential.location.LocationAreaDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationAreaImpl;
import fr.ifremer.adagio.core.dao.referential.location.LocationClassification;
import fr.ifremer.adagio.core.dao.referential.location.LocationLevel;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class LocationAreaDaoBase
extends HibernateDaoSupport
implements LocationAreaDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("LocationArea.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(LocationAreaImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (LocationArea)entity);
    }

    @Override
    public LocationArea load(Integer id) {
        return (LocationArea)this.load(0, id);
    }

    @Override
    public Collection<LocationArea> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(LocationAreaImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public LocationArea create(LocationArea locationArea) {
        return (LocationArea)this.create(0, locationArea);
    }

    @Override
    public Object create(int transform, LocationArea locationArea) {
        if (locationArea == null) {
            throw new IllegalArgumentException("LocationArea.create - 'locationArea' can not be null");
        }
        this.getHibernateTemplate().save((Object)locationArea);
        return this.transformEntity(transform, locationArea);
    }

    @Override
    public Collection<LocationArea> create(Collection<LocationArea> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<LocationArea> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationArea.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LocationAreaDaoBase.this.create(transform, (LocationArea)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public LocationArea create(String label, String name, Timestamp updateDate, Float bathymetry, Short utFormat, Boolean daylightSavingTime, LocationLevel locationLevel, Status status, LocationClassification locationClassification, String position) {
        return (LocationArea)this.create(0, label, name, updateDate, bathymetry, utFormat, daylightSavingTime, locationLevel, status, locationClassification, position);
    }

    @Override
    public Object create(int transform, String label, String name, Timestamp updateDate, Float bathymetry, Short utFormat, Boolean daylightSavingTime, LocationLevel locationLevel, Status status, LocationClassification locationClassification, String position) {
        LocationAreaImpl entity = new LocationAreaImpl();
        entity.setLabel(label);
        entity.setName(name);
        entity.setUpdateDate(updateDate);
        entity.setBathymetry(bathymetry);
        entity.setUtFormat(utFormat);
        entity.setDaylightSavingTime(daylightSavingTime);
        entity.setLocationLevel(locationLevel);
        entity.setStatus(status);
        entity.setLocationClassification(locationClassification);
        entity.setPosition(position);
        return this.create(transform, entity);
    }

    @Override
    public LocationArea create(LocationClassification locationClassification, LocationLevel locationLevel, String name, String position, Status status) {
        return (LocationArea)this.create(0, locationClassification, locationLevel, name, position, status);
    }

    @Override
    public Object create(int transform, LocationClassification locationClassification, LocationLevel locationLevel, String name, String position, Status status) {
        LocationAreaImpl entity = new LocationAreaImpl();
        entity.setLocationClassification(locationClassification);
        entity.setLocationLevel(locationLevel);
        entity.setName(name);
        entity.setPosition(position);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(LocationArea locationArea) {
        if (locationArea == null) {
            throw new IllegalArgumentException("LocationArea.update - 'locationArea' can not be null");
        }
        this.getHibernateTemplate().update((Object)locationArea);
    }

    @Override
    public void update(final Collection<LocationArea> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationArea.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LocationAreaDaoBase.this.update((LocationArea)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(LocationArea locationArea) {
        if (locationArea == null) {
            throw new IllegalArgumentException("LocationArea.remove - 'locationArea' can not be null");
        }
        this.getHibernateTemplate().delete((Object)locationArea);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("LocationArea.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        LocationArea entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<LocationArea> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationArea.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, LocationArea entity) {
        LocationArea target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected LocationArea toEntity(Object[] row) {
        LocationArea target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof LocationArea)) continue;
                target = (LocationArea)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LocationAreaImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LocationAreaImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<LocationArea> search(Search search) {
        return this.search(0, search);
    }
}

