/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.vessel;

import fr.ifremer.adagio.core.dao.data.vessel.VesselExtendDao;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.dao.referential.StatusImpl;
import fr.ifremer.adagio.core.dao.referential.VesselType;
import fr.ifremer.adagio.core.dao.referential.VesselTypeImpl;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.location.LocationImpl;
import fr.ifremer.adagio.core.dao.referential.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselDaoBase;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselFeatures;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselFeaturesDao;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselFeaturesImpl;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselRegistrationPeriod;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselRegistrationPeriodDao;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselRegistrationPeriodPK;
import fr.ifremer.adagio.core.dao.technical.hibernate.TemporaryDataHelper;
import java.io.Serializable;
import java.sql.Date;
import javax.annotation.Resource;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository(value="vesselExtendDao")
@Lazy
public class VesselDaoImpl
extends VesselDaoBase
implements VesselExtendDao {
    @Resource(name="vesselFeaturesDao")
    protected VesselFeaturesDao vesselFeaturesDao;
    @Resource(name="vesselRegistrationPeriodDao")
    protected VesselRegistrationPeriodDao vesselRegistrationPeriodDao;

    @Autowired
    public VesselDaoImpl(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public Vessel createAsTemporary(String nationalRegistrationCode, String internationalRegistrationCode, Integer registrationLocationId, String name, Integer vesselTypeId) {
        Session session = this.getSession(false);
        Vessel target = Vessel.Factory.newInstance();
        String internalCode = nationalRegistrationCode;
        if (internalCode == null) {
            internalCode = internationalRegistrationCode;
        }
        if (internalCode == null) {
            internalCode = name;
        }
        target.setCode("#TEMP\u00bf" + internalCode);
        target.setVesselType((VesselType)session.load(VesselTypeImpl.class, (Serializable)vesselTypeId));
        target.setStatus((Status)session.load(StatusImpl.class, (Serializable)((Object)StatusCode.TEMPORARY.getValue())));
        target = this.create(target);
        VesselRegistrationPeriod vrp = VesselRegistrationPeriod.Factory.newInstance();
        VesselRegistrationPeriodPK vrpPK = new VesselRegistrationPeriodPK();
        vrpPK.setStartDateTime(new Date(0L));
        vrpPK.setVessel(target);
        vrpPK.setRegistrationLocation((Location)session.load(LocationImpl.class, (Serializable)registrationLocationId));
        vrp.setVesselRegistrationPeriodPk(vrpPK);
        vrp.setRegistrationCode(nationalRegistrationCode);
        vrp.setInternationalRegistrationCode(internationalRegistrationCode);
        target.getVesselRegistrationPeriods().add(vrp);
        this.vesselRegistrationPeriodDao.create(vrp);
        VesselFeatures vesselFeatures = VesselFeatures.Factory.newInstance();
        Integer vesselFeaturesId = (Integer)TemporaryDataHelper.getNewNegativeIdForTemporaryData(session, VesselFeaturesImpl.class);
        vesselFeatures.setId(vesselFeaturesId);
        vesselFeatures.setStartDateTime(new Date(0L));
        vesselFeatures.setName(name);
        vesselFeatures.setIsFPC(false);
        vesselFeatures.setVessel(target);
        target.getVesselFeatures().add(vesselFeatures);
        this.vesselFeaturesDao.create(vesselFeatures);
        return target;
    }
}

