package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportProtocolAction.java 630 2013-03-15 10:20:17Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.4.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/home/ExportProtocolAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * Opens a file chooser and exports the protocol into the selected file.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ExportProtocolAction extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ExportProtocolAction.class);

    protected File file;

    public ExportProtocolAction(SelectCruiseUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            // choose file to export
            file = TuttiUIUtil.chooseFile(
                    getContext().getMainUI(),
                    _("tutti.selectCruise.title.choose.exportFile"),
                    _("tutti.selectCruise.action.chooseProtocolFile"),
                    "^.+\\.tuttiProtocol$", _("tutti.common.file.protocol")
            );
            doAction = file != null;
            if (doAction) {
                file = TuttiIOUtil.addExtensionIfMissing(file, ".tuttiProtocol");

                // ask user to confirm overwrite.
                doAction = getHandler().askOverwriteFile(file);
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        TuttiProtocol protocol = getModel().getProtocol();
        Preconditions.checkNotNull(protocol);
        Preconditions.checkNotNull(file);

        if (log.isInfoEnabled()) {
            log.info("Will save protocol " + protocol.getId() +
                     " to file: " + file);
        }

        // export protocol
        TuttiProtocolImportExportService service =
                getContext().getTuttiProtocolImportExportService();
        service.exportProtocol(protocol, file);

        sendMessage("Protocole [" + protocol.getName() +
                    "] exporté dans le fichier " + file.getName() + ".");

        getHandler().resetEditProtolAction();
    }
}
