/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.protocol;

import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class SpeciesRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_SPECIES = "species";
    public static final String PROPERTY_SPECIES_REFERENCE_TAXON_ID = "speciesReferenceTaxonId";
    public static final String PROPERTY_SPECIES_REF_TAX_CODE = "speciesRefTaxCode";
    public static final String PROPERTY_SPECIES_NAME = "speciesName";
    public static final String PROPERTY_SPECIES_SURVEY_CODE = "speciesSurveyCode";
    public static final String PROPERTY_SIZE_ENABLED = "sizeEnabled";
    public static final String PROPERTY_SEX_ENABLED = "sexEnabled";
    public static final String PROPERTY_MATURITY_ENABLED = "maturityEnabled";
    public static final String PROPERTY_AGE_ENABLED = "ageEnabled";
    public static final String PROPERTY_LENGTH_STEP_PMFM = "lengthStepPmfm";
    public static final String PROPERTY_LENGTH_STEP_PMFM_PARAMETER_NAME = "lengthStepPmfmParameterName";
    public static final String PROPERTY_LENGTH_STEP_PMFM_MATRIX_NAME = "lengthStepPmfmMatrixName";
    public static final String PROPERTY_LENGTH_STEP_PMFM_FRACTION_NAME = "lengthStepPmfmFractionName";
    public static final String PROPERTY_LENGTH_STEP_PMFM_METHOD_NAME = "lengthStepPmfmMethodName";
    public static final String PROPERTY_LENGTH_STEP_PMFM_ID = "lengthStepPmfmId";
    public static final String PROPERTY_WEIGHT_ENABLED = "weightEnabled";
    public static final String PROPERTY_COUNT_IF_NO_FREQUENCY_ENABLED = "countIfNoFrequencyEnabled";
    public static final String PROPERTY_CALCIFY_SAMPLE_ENABLED = "calcifySampleEnabled";
    protected final SpeciesProtocol delegate = TuttiBeanFactory.newSpeciesProtocol();
    protected Species species;
    protected Caracteristic lengthStepPmfm;

    public SpeciesRow() {
        this.delegate.setMadeFromAReferentTaxon(true);
    }

    public Species getSpecies() {
        return this.species;
    }

    public Integer getSpeciesReferenceTaxonId() {
        return this.species == null ? null : this.delegate.getSpeciesReferenceTaxonId();
    }

    public String getSpeciesName() {
        return this.species == null ? null : this.species.getName();
    }

    public void setSpeciesName(String name) {
        if (!StringUtils.isEmpty((CharSequence)name)) {
            boolean madeFromAReferentTaxon = this.isMadeFromAReferentTaxon();
            this.setMadeFromAReferentTaxon(madeFromAReferentTaxon && this.species != null && this.species.getName().equals(name));
        }
    }

    public String getSpeciesRefTaxCode() {
        return this.species.getRefTaxCode();
    }

    public void setSpeciesRefTaxCode(String refTaxCode) {
        if (!StringUtils.isEmpty((CharSequence)refTaxCode)) {
            boolean madeFromAReferentTaxon = this.isMadeFromAReferentTaxon();
            this.setMadeFromAReferentTaxon(madeFromAReferentTaxon && this.species != null && this.species.getRefTaxCode().equals(refTaxCode));
        }
    }

    public void setSpecies(Species species) {
        this.species = species;
        this.delegate.setSpeciesReferenceTaxonId(species == null ? null : species.getReferenceTaxonId());
    }

    public String getSpeciesSurveyCode() {
        return this.delegate.getSpeciesSurveyCode();
    }

    public void setSpeciesSurveyCode(String speciesSuurveyCode) {
        this.delegate.setSpeciesSurveyCode(speciesSuurveyCode);
    }

    public Caracteristic getLengthStepPmfm() {
        return this.lengthStepPmfm;
    }

    public void setLengthStepPmfm(Caracteristic lengthStepPmfm) {
        this.lengthStepPmfm = lengthStepPmfm;
        this.delegate.setLengthStepPmfmId(lengthStepPmfm == null ? null : lengthStepPmfm.getId());
    }

    public String getLengthStepPmfmId() {
        return this.delegate.getLengthStepPmfmId();
    }

    public String getLengthStepPmfmParameterName() {
        return this.lengthStepPmfm == null ? null : this.lengthStepPmfm.getParameterName();
    }

    public String getLengthStepPmfmMethodName() {
        return this.lengthStepPmfm == null ? null : this.lengthStepPmfm.getMethodName();
    }

    public String getLengthStepPmfmMatrixName() {
        return this.lengthStepPmfm == null ? null : this.lengthStepPmfm.getMatrixName();
    }

    public String getLengthStepPmfmFractionName() {
        return this.lengthStepPmfm == null ? null : this.lengthStepPmfm.getFractionName();
    }

    public boolean isSizeEnabled() {
        return this.delegate.isSizeEnabled();
    }

    public void setSizeEnabled(boolean sizeEnabled) {
        this.delegate.setSizeEnabled(sizeEnabled);
    }

    public boolean isSexEnabled() {
        return this.delegate.isSexEnabled();
    }

    public void setSexEnabled(boolean sexEnabled) {
        this.delegate.setSexEnabled(sexEnabled);
    }

    public boolean isMaturityEnabled() {
        return this.delegate.isMaturityEnabled();
    }

    public void setMaturityEnabled(boolean maturityEnabled) {
        this.delegate.setMaturityEnabled(maturityEnabled);
    }

    public boolean isAgeEnabled() {
        return this.delegate.isAgeEnabled();
    }

    public void setAgeEnabled(boolean ageEnabled) {
        this.delegate.setAgeEnabled(ageEnabled);
    }

    public boolean isWeightEnabled() {
        return this.delegate.isWeightEnabled();
    }

    public void setWeightEnabled(boolean weightEnabled) {
        this.delegate.setWeightEnabled(weightEnabled);
    }

    public boolean isCountIfNoFrequencyEnabled() {
        return this.delegate.isCountIfNoFrequencyEnabled();
    }

    public void setCountIfNoFrequencyEnabled(boolean countIfNoFrequencyEnabled) {
        this.delegate.setCountIfNoFrequencyEnabled(countIfNoFrequencyEnabled);
    }

    public boolean isCalcifySampleEnabled() {
        return this.delegate.isCalcifySampleEnabled();
    }

    public void setCalcifySampleEnabled(boolean calcifySampleEnabled) {
        this.delegate.setCalcifySampleEnabled(calcifySampleEnabled);
    }

    public boolean isMadeFromAReferentTaxon() {
        return this.delegate.isMadeFromAReferentTaxon();
    }

    public void setMadeFromAReferentTaxon(boolean referent) {
        this.delegate.setMadeFromAReferentTaxon(referent);
    }
}

