/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.renderer;

import java.awt.Component;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.decorator.Decorator;

public class FilteredDecoratorListCellRenderer
extends DecoratorListCellRenderer {
    protected String filterText;
    protected Pattern pattern;
    protected boolean highlightFilterText = false;

    public FilteredDecoratorListCellRenderer(Decorator<?> decorator) {
        super(decorator);
    }

    public FilteredDecoratorListCellRenderer(ListCellRenderer delegate, Decorator<?> decorator) {
        super(delegate, decorator);
    }

    public FilteredDecoratorListCellRenderer(ListCellRenderer delegate, Decorator<?> decorator, boolean highlightFilterText) {
        super(delegate, decorator);
        this.highlightFilterText = highlightFilterText;
    }

    public String getFilterText() {
        return this.filterText;
    }

    public void setFilterText(String filterText) {
        this.filterText = filterText;
        this.computePattern();
    }

    public boolean isHighlightFilterText() {
        return this.highlightFilterText;
    }

    public void setHighlightFilterText(boolean highlightFilterText) {
        this.highlightFilterText = highlightFilterText;
        this.computePattern();
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Matcher matcher;
        if (!(value instanceof String) && this.decorator != null) {
            value = this.decorator.toString(value);
        }
        String stringValue = String.valueOf(value);
        if (this.pattern != null && (matcher = this.pattern.matcher(stringValue)).find()) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (int g = 1; g <= matcher.groupCount(); ++g) {
                String match = matcher.group(g);
                int indexOfMatch = stringValue.indexOf(match, i);
                sb.append(stringValue.substring(i, indexOfMatch)).append("<span style='background:#FFFF00'>").append(match).append("</span>");
                i = indexOfMatch + match.length();
            }
            sb.append(stringValue.substring(i));
            stringValue = "<html>" + sb.toString() + "</html>";
        }
        return this.delegate.getListCellRendererComponent(list, stringValue, index, isSelected, cellHasFocus);
    }

    protected void computePattern() {
        if (this.highlightFilterText && !StringUtils.isEmpty((CharSequence)StringUtils.remove((String)this.filterText, (char)'*'))) {
            String patternText = "(" + this.filterText.replace("*", ").*(") + ").*";
            patternText = StringUtils.remove((String)patternText, (String)"()");
            this.pattern = Pattern.compile(patternText, 2);
        } else {
            this.pattern = null;
        }
    }
}

