/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.fs;

import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.HashSet;
import java.util.Set;

public class DefaultFileManagerFactory
implements FileManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFileManagerFactory.class);
    private boolean reloadingConfigs;
    private FileManager fileManager;
    private Container container;

    @Inject(value="system")
    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    @Inject(value="reloadXmlConfiguration", required=false)
    public void setReloadingConfigs(String reloadingConfigs) {
        this.reloadingConfigs = Boolean.parseBoolean(reloadingConfigs);
    }

    public FileManager getFileManager() {
        Set<String> names = this.container.getInstanceNames(FileManager.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found following implementations of FileManager interface: #0", names.toString());
        }
        HashSet<FileManager> internals = new HashSet<FileManager>();
        HashSet<FileManager> users = new HashSet<FileManager>();
        for (String fmName : names) {
            FileManager fm = this.container.getInstance(FileManager.class, fmName);
            if (fm.internal()) {
                internals.add(fm);
                continue;
            }
            users.add(fm);
        }
        for (FileManager fm : users) {
            if (!fm.support()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using FileManager implementation [#0]", fm.getClass().getSimpleName());
            }
            fm.setReloadingConfigs(this.reloadingConfigs);
            return fm;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No user defined FileManager, looking up for internal implementations!", new String[0]);
        }
        for (FileManager fm : internals) {
            if (!fm.support()) continue;
            return fm;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using default implementation of FileManager provided under name [system]: #0", this.fileManager.getClass().getSimpleName());
        }
        this.fileManager.setReloadingConfigs(this.reloadingConfigs);
        return this.fileManager;
    }
}

