/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.AboutPanel;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class AboutPanelHandler {
    private static final Log log = LogFactory.getLog(AboutPanelHandler.class);
    protected final AboutPanel ui;
    protected final Action closeAction = new AbstractAction("close"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog container = AboutPanelHandler.this.ui.getParentContainer(JDialog.class);
            if (container != null) {
                container.dispose();
            } else {
                AboutPanelHandler.this.ui.setVisible(false);
            }
        }
    };

    public AboutPanelHandler(AboutPanel ui) {
        this.ui = ui;
    }

    public void setLicenseFile(String filename) {
        String load = this.load(filename);
        this.ui.setLicenseText(load);
    }

    public void setThirdpartyFile(String filename) {
        String load = this.load(filename);
        this.ui.setThirdpartyText(load);
    }

    public void buildTopPanel() {
        JLabel labelIcon;
        if (this.ui.iconPath != null) {
            ImageIcon logoIcon = Resource.getIcon((String)this.ui.iconPath);
            labelIcon = new JLabel(logoIcon);
        } else {
            labelIcon = new JLabel();
        }
        this.ui.topPanel.add(labelIcon);
    }

    public void init() {
        if (this.ui.getAboutText() == null) {
            this.ui.tabs.remove(this.ui.aboutContent);
        }
        if (this.ui.getLicenseText() == null) {
            this.ui.tabs.remove(this.ui.licenseContent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AboutPanelHandler.this.ui.licenseTextArea.setCaretPosition(0);
                }
            });
        }
        if (this.ui.getThirdpartyText() == null) {
            this.ui.tabs.remove(this.ui.thirdpartyContent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AboutPanelHandler.this.ui.thirdpartyTextArea.setCaretPosition(0);
                }
            });
        }
    }

    public void showInDialog(Frame ui, boolean undecorated) {
        JDialog f = new JDialog(ui, true);
        f.add((Component)((Object)this.ui));
        if (this.ui.iconPath != null) {
            f.setIconImage(SwingUtil.createIcon((String)this.ui.iconPath).getImage());
        }
        f.setResizable(false);
        f.setSize(550, 450);
        f.setUndecorated(undecorated);
        JRootPane rootPane = f.getRootPane();
        rootPane.setDefaultButton(this.ui.close);
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "close");
        rootPane.getActionMap().put("close", this.closeAction);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Component ui = (Component)e.getSource();
                if (log.isInfoEnabled()) {
                    log.info((Object)("destroy ui " + ui));
                }
                JAXXUtil.destroy((Component)ui);
                JAXXUtil.destroy((Component)((Object)AboutPanelHandler.this.ui));
            }
        });
        SwingUtil.center((Component)ui, (Component)f);
        f.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String load(String filename) {
        InputStream licenseStream = this.getClass().getResourceAsStream("/" + filename);
        String result = null;
        try {
            if (licenseStream != null) {
                result = IOUtils.toString((InputStream)licenseStream);
            }
        }
        catch (IOException ex) {
        }
        finally {
            if (licenseStream != null) {
                try {
                    licenseStream.close();
                }
                catch (IOException ex) {
                    log.error((Object)("could not close file " + filename));
                }
            }
        }
        if (result == null) {
            result = "resource " + filename + " not found";
        }
        return result;
    }

    void $afterCompleteSetup() {
        this.buildTopPanel();
        this.ui.close.setText(I18n._((String)"aboutframe.ok", (Object[])new Object[0]));
    }
}

