package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class MarineLitterBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<MarineLitterBatchUIModel, MarineLitterBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MARINE_LITTER_BATCH_ATTACHMENTS_BUTTON_ENABLED = "marineLitterBatchAttachmentsButton.enabled";
    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_MODEL = "marineLitterTotalWeightField.model";
    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "marineLitterTotalWeightField.numberPattern";
    public static final String BINDING_REMOVE_MARINE_LITTER_BATCH_MENU_ENABLED = "removeMarineLitterBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(MarineLitterBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton createMarineLitterBatchButton;
    protected MarineLitterBatchUI editMarineLitterBatchTopPanel = this;
    protected Table form;
    protected MarineLitterBatchUIHandler handler;
    protected ButtonAttachment marineLitterBatchAttachmentsButton;
    protected JToolBar marineLitterBatchTabToolBar;
    @ValidatorField( validatorId = "validator",  propertyName = "marineLitterTotalWeight",  editorName = "marineLitterTotalWeightField")
    protected NumberEditor marineLitterTotalWeightField;
    protected JLabel marineLitterTotalWeightLabel;
    protected MarineLitterBatchUIModel model;
    protected JMenuItem removeMarineLitterBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<MarineLitterBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MarineLitterBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            MarineLitterBatchUIHandler handler = new MarineLitterBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public MarineLitterBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MarineLitterBatchUI() {
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MarineLitterBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MarineLitterBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createMarineLitterBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createBatch();
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCreateMarineLitterBatchButton() {
        return createMarineLitterBatchButton;
    }

    public Table getForm() {
        return form;
    }

    public MarineLitterBatchUIHandler getHandler() {
        return handler;
    }

    public ButtonAttachment getMarineLitterBatchAttachmentsButton() {
        return marineLitterBatchAttachmentsButton;
    }

    public JToolBar getMarineLitterBatchTabToolBar() {
        return marineLitterBatchTabToolBar;
    }

    public NumberEditor getMarineLitterTotalWeightField() {
        return marineLitterTotalWeightField;
    }

    public JLabel getMarineLitterTotalWeightLabel() {
        return marineLitterTotalWeightLabel;
    }

    public MarineLitterBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveMarineLitterBatchMenu() {
        return removeMarineLitterBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<MarineLitterBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditMarineLitterBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(marineLitterBatchTabToolBar);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(marineLitterTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(marineLitterTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(tableToolbar, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMarineLitterBatchTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterBatchTabToolBar.add(marineLitterBatchAttachmentsButton);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeMarineLitterBatchMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tuttihelp.editMarineLitterBatch.help"));
    }

    protected void createCreateMarineLitterBatchButton() {
        $objectMap.put("createMarineLitterBatchButton", createMarineLitterBatchButton = new JButton());
        
        createMarineLitterBatchButton.setName("createMarineLitterBatchButton");
        createMarineLitterBatchButton.setText(_("tutti.editMarineLitterBatch.action.createBatch"));
        createMarineLitterBatchButton.setToolTipText(_("tutti.editMarineLitterBatch.action.createBatch.tip"));
        createMarineLitterBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createMarineLitterBatchButton"));
        createMarineLitterBatchButton.putClientProperty("help", "tutti.editMarineLitterBatch.action.createBatch.help");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(MarineLitterBatchUIHandler.class));
    }

    protected void createMarineLitterBatchAttachmentsButton() {
        $objectMap.put("marineLitterBatchAttachmentsButton", marineLitterBatchAttachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        marineLitterBatchAttachmentsButton.setName("marineLitterBatchAttachmentsButton");
    }

    protected void createMarineLitterBatchTabToolBar() {
        $objectMap.put("marineLitterBatchTabToolBar", marineLitterBatchTabToolBar = new JToolBar());
        
        marineLitterBatchTabToolBar.setName("marineLitterBatchTabToolBar");
        marineLitterBatchTabToolBar.setFloatable(false);
        marineLitterBatchTabToolBar.setOpaque(false);
        marineLitterBatchTabToolBar.setBorderPainted(false);
    }

    protected void createMarineLitterTotalWeightField() {
        $objectMap.put("marineLitterTotalWeightField", marineLitterTotalWeightField = new NumberEditor(this));
        
        marineLitterTotalWeightField.setName("marineLitterTotalWeightField");
        marineLitterTotalWeightField.setProperty("marineLitterTotalWeight");
        marineLitterTotalWeightField.setUseFloat(false);
        marineLitterTotalWeightField.setShowReset(true);
        marineLitterTotalWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createMarineLitterTotalWeightLabel() {
        $objectMap.put("marineLitterTotalWeightLabel", marineLitterTotalWeightLabel = new JLabel());
        
        marineLitterTotalWeightLabel.setName("marineLitterTotalWeightLabel");
        marineLitterTotalWeightLabel.setText(_("tutti.editMarineLitterBatch.field.marineLitterTotalWeight"));
        marineLitterTotalWeightLabel.setToolTipText(_("tutti.editMarineLitterBatch.field.marineLitterTotalWeight.tip"));
        marineLitterTotalWeightLabel.putClientProperty("help", "tutti.editMarineLitterBatch.field.marineLitterTotalWeight.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(MarineLitterBatchUIModel.class));
    }

    protected void createRemoveMarineLitterBatchMenu() {
        $objectMap.put("removeMarineLitterBatchMenu", removeMarineLitterBatchMenu = new JMenuItem());
        
        removeMarineLitterBatchMenu.setName("removeMarineLitterBatchMenu");
        removeMarineLitterBatchMenu.setText(_("tutti.editMarineLitterBatch.action.removeBatch"));
        removeMarineLitterBatchMenu.setToolTipText(_("tutti.editMarineLitterBatch.action.removeBatch.tip"));
        removeMarineLitterBatchMenu.putClientProperty("help", "tutti.editMarineLitterBatch.action.removeBatch.help");
        removeMarineLitterBatchMenu.putClientProperty("tuttiAction", RemoveMarineLitterBatchAction.class);
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editMarineLitterBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(MarineLitterBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditMarineLitterBatchTopPanel();
        addChildrenToValidator();
        addChildrenToMarineLitterBatchTabToolBar();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createMarineLitterBatchButton);
        addChildrenToTableScrollPane();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        removeMarineLitterBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeMarineLitterBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editMarineLitterBatch.action.removeBatch.mnemonic"),'Z'));
        marineLitterTotalWeightLabel.setLabelFor(marineLitterTotalWeightField);
        marineLitterTotalWeightField.setBean(model);
        marineLitterTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        marineLitterTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        createMarineLitterBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        createMarineLitterBatchButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editMarineLitterBatch.action.createBatch.mnemonic"),'Z'));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editMarineLitterBatchTopPanel, "tuttihelp.editMarineLitterBatch.help");
        registerHelpId(_broker, removeMarineLitterBatchMenu, "tutti.editMarineLitterBatch.action.removeBatch.help");
        registerHelpId(_broker, marineLitterTotalWeightLabel, "tutti.editMarineLitterBatch.field.marineLitterTotalWeight.help");
        registerHelpId(_broker, createMarineLitterBatchButton, "tutti.editMarineLitterBatch.action.createBatch.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editMarineLitterBatchTopPanel", editMarineLitterBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createMarineLitterBatchTabToolBar();
        createMarineLitterBatchAttachmentsButton();
        createTablePopup();
        createRemoveMarineLitterBatchMenu();
        createForm();
        createMarineLitterTotalWeightLabel();
        createMarineLitterTotalWeightField();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateMarineLitterBatchButton();
        createTableScrollPane();
        createTable();
        // inline creation of editMarineLitterBatchTopPanel
        setName("editMarineLitterBatchTopPanel");
        setLayout(new BorderLayout());
        editMarineLitterBatchTopPanel.putClientProperty("help", "tuttihelp.editMarineLitterBatch.help");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_BATCH_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("objectId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterBatchAttachmentsButton.setEnabled(model.getObjectId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("objectId", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_MARINE_LITTER_BATCH_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeMarineLitterBatchMenu.setEnabled(model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterTotalWeightField.setModel(model.getMarineLitterTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterTotalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                marineLitterTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
    }

}