/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.regulation;

import fr.ifremer.adagio.core.dao.referential.regulation.CorpusImpl;
import fr.ifremer.adagio.core.dao.referential.regulation.CorpusType;
import fr.ifremer.adagio.core.dao.referential.regulation.Fishery;
import fr.ifremer.adagio.core.dao.referential.regulation.MinimumSizeAllowed;
import fr.ifremer.adagio.core.dao.referential.regulation.RightToProduce;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public abstract class Corpus
implements Serializable {
    private static final long serialVersionUID = -161415443252679993L;
    private Integer id;
    private String name;
    private String description;
    private Date startDate;
    private Date endDate;
    private Timestamp updateDate;
    private CorpusType corpusType;
    private RightToProduce rightToProduce;
    private Collection<MinimumSizeAllowed> minimumSizeAlloweds = new HashSet<MinimumSizeAllowed>();
    private Collection<Fishery> fisheries = new HashSet<Fishery>();

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Timestamp getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Timestamp updateDate) {
        this.updateDate = updateDate;
    }

    public CorpusType getCorpusType() {
        return this.corpusType;
    }

    public void setCorpusType(CorpusType corpusType) {
        this.corpusType = corpusType;
    }

    public RightToProduce getRightToProduce() {
        return this.rightToProduce;
    }

    public void setRightToProduce(RightToProduce rightToProduce) {
        this.rightToProduce = rightToProduce;
    }

    public Collection<MinimumSizeAllowed> getMinimumSizeAlloweds() {
        return this.minimumSizeAlloweds;
    }

    public void setMinimumSizeAlloweds(Collection<MinimumSizeAllowed> minimumSizeAlloweds) {
        this.minimumSizeAlloweds = minimumSizeAlloweds;
    }

    public Collection<Fishery> getFisheries() {
        return this.fisheries;
    }

    public void setFisheries(Collection<Fishery> fisheries) {
        this.fisheries = fisheries;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Corpus)) {
            return false;
        }
        Corpus that = (Corpus)object;
        return this.id != null && that.getId() != null && this.id.equals(that.getId());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());
        return hashCode;
    }

    public static final class Factory {
        public static Corpus newInstance() {
            CorpusImpl entity = new CorpusImpl();
            return entity;
        }

        public static Corpus newInstance(String name, Date startDate, CorpusType corpusType, Collection<Fishery> fisheries) {
            Corpus entity = Factory.newInstance();
            entity.setName(name);
            entity.setStartDate(startDate);
            entity.setCorpusType(corpusType);
            entity.setFisheries(fisheries);
            return entity;
        }

        public static Corpus newInstance(String name, String description, Date startDate, Date endDate, Timestamp updateDate, CorpusType corpusType, RightToProduce rightToProduce, Collection<MinimumSizeAllowed> minimumSizeAlloweds, Collection<Fishery> fisheries) {
            Corpus entity = Factory.newInstance();
            entity.setName(name);
            entity.setDescription(description);
            entity.setStartDate(startDate);
            entity.setEndDate(endDate);
            entity.setUpdateDate(updateDate);
            entity.setCorpusType(corpusType);
            entity.setRightToProduce(rightToProduce);
            entity.setMinimumSizeAlloweds(minimumSizeAlloweds);
            entity.setFisheries(fisheries);
            return entity;
        }
    }
}

