/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao;

import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.context.support.AbstractApplicationContext;

public class BeanLocator {
    private static final BeanLocator instance = new BeanLocator();
    private BeanFactoryReference beanFactoryReference;
    private String beanFactoryReferenceLocation;
    private String beanRefFactoryReferenceId;
    private final String DEFAULT_BEAN_REFERENCE_LOCATION = "beanRefFactory.xml";
    private final String DEFAULT_BEAN_REFERENCE_ID = "beanRefFactory";

    private BeanLocator() {
    }

    public static final BeanLocator instance() {
        return instance;
    }

    public synchronized void init() {
        this.getContext();
    }

    public synchronized void init(String beanFactoryReferenceLocation, String beanRefFactoryReferenceId) {
        this.beanFactoryReferenceLocation = beanFactoryReferenceLocation;
        this.beanRefFactoryReferenceId = beanRefFactoryReferenceId;
        this.beanFactoryReference = null;
        this.getContext();
    }

    public synchronized void init(String beanFactoryReferenceLocation) {
        this.beanFactoryReferenceLocation = beanFactoryReferenceLocation;
        this.beanFactoryReference = null;
        this.getContext();
    }

    protected synchronized ApplicationContext getContext() {
        if (this.beanFactoryReference == null) {
            if (this.beanFactoryReferenceLocation == null) {
                this.beanFactoryReferenceLocation = "beanRefFactory.xml";
            }
            if (this.beanRefFactoryReferenceId == null) {
                this.beanRefFactoryReferenceId = "beanRefFactory";
            }
            BeanFactoryLocator beanFactoryLocator = ContextSingletonBeanFactoryLocator.getInstance((String)this.beanFactoryReferenceLocation);
            this.beanFactoryReference = beanFactoryLocator.useBeanFactory(this.beanRefFactoryReferenceId);
        }
        return (ApplicationContext)this.beanFactoryReference.getFactory();
    }

    public synchronized void shutdown() {
        ((AbstractApplicationContext)this.getContext()).close();
        if (this.beanFactoryReference != null) {
            this.beanFactoryReference.release();
            this.beanFactoryReference = null;
        }
    }

    public Object getBean(String name) {
        return this.getContext().getBean(name);
    }
}

