/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.io.Serializable;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.orm.jpa.EntityManagerFactoryPlusOperations;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerPlusOperations;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;

public class DefaultJpaDialect
implements JpaDialect,
Serializable {
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("Standard JPA does not support custom isolation levels - use a special JpaDialect for your JPA implementation");
        }
        entityManager.getTransaction().begin();
        return null;
    }

    public Object prepareTransaction(EntityManager entityManager, boolean readOnly, String name) throws PersistenceException {
        return null;
    }

    public void cleanupTransaction(Object transactionData) {
    }

    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        return null;
    }

    public void releaseJdbcConnection(ConnectionHandle conHandle, EntityManager em) throws PersistenceException, SQLException {
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
    }

    public boolean supportsEntityManagerFactoryPlusOperations() {
        return false;
    }

    public boolean supportsEntityManagerPlusOperations() {
        return false;
    }

    public EntityManagerFactoryPlusOperations getEntityManagerFactoryPlusOperations(EntityManagerFactory rawEntityManager) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + " does not support EntityManagerFactoryPlusOperations");
    }

    public EntityManagerPlusOperations getEntityManagerPlusOperations(EntityManager rawEntityManager) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + " does not support EntityManagerPlusOperations");
    }
}

