package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

/*
 * #%L
 * Tutti :: UI
 * $Id: BenthosBatchTableModel.java 629 2013-03-15 09:48:31Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/BenthosBatchTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import org.jdesktop.swingx.table.TableColumnModelExt;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class BenthosBatchTableModel extends AbstractTuttiTableModel<BenthosBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final ColumnIdentifier<BenthosBatchRowModel> SPECIES_BY_CODE = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_SPECIES,
            n_("tutti.editBenthosBatch.table.header.speciesByCode"),
            n_("tutti.editBenthosBatch.table.header.speciesByCode"));

    public static final ColumnIdentifier<BenthosBatchRowModel> SPECIES_BY_GENUS_CODE = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_SPECIES,
            n_("tutti.editBenthosBatch.table.header.speciesByGenusCode"),
            n_("tutti.editBenthosBatch.table.header.speciesByGenusCode"));

    public static final ColumnIdentifier<BenthosBatchRowModel> WEIGHT = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_WEIGHT,
            n_("tutti.editBenthosBatch.table.header.weight"),
            n_("tutti.editBenthosBatch.table.header.weight"));

    public static final ColumnIdentifier<BenthosBatchRowModel> NUMBER = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_NUMBER,
            n_("tutti.editBenthosBatch.table.header.number"),
            n_("tutti.editBenthosBatch.table.header.number"));


    public static final ColumnIdentifier<BenthosBatchRowModel> SAMPLE_WEIGHT = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_SAMPLE_WEIGHT,
            n_("tutti.editBenthosBatch.table.header.sampleWeight"),
            n_("tutti.editBenthosBatch.table.header.sampleWeight"));

    public static final ColumnIdentifier<BenthosBatchRowModel> COMMENT = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_COMMENT,
            n_("tutti.editBenthosBatch.table.header.comment"),
            n_("tutti.editBenthosBatch.table.header.comment"));

    public static final ColumnIdentifier<BenthosBatchRowModel> ATTACHMENT = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_ATTACHMENT,
            n_("tutti.editBenthosBatch.table.header.file"),
            n_("tutti.editBenthosBatch.table.header.file"));

    public static final ColumnIdentifier<BenthosBatchRowModel> SPECIES_TO_CONFIRM = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_SPECIES_TO_CONFIRM,
            n_("tutti.editBenthosBatch.table.header.toConfirm"),
            n_("tutti.editBenthosBatch.table.header.toConfirm"));

    public BenthosBatchTableModel(TableColumnModelExt columnModel) {
        super(columnModel, true, true);
        setNoneEditableCols();
    }

    @Override
    public BenthosBatchRowModel createNewRow() {
        BenthosBatchRowModel result = new BenthosBatchRowModel();

        // by default empty row is not valid
        result.setValid(false);
        return result;
    }

}