package fr.ifremer.tutti.ui.swing.content.db;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.UpdateReferentialAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class DbManagerUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<TuttiUIContext, DbManagerUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLOSE_DB_BUTTON_ENABLED = "closeDbButton.enabled";
    public static final String BINDING_EXPORT_AND_CLEAN_DB_BUTTON_ENABLED = "exportAndCleanDbButton.enabled";
    public static final String BINDING_EXPORT_DB_BUTTON_ENABLED = "exportDbButton.enabled";
    public static final String BINDING_INFORMATION_LABEL_TEXT = "informationLabel.text";
    public static final String BINDING_NO_DB_ACTIONS_VISIBLE = "noDbActions.visible";
    public static final String BINDING_OPEN_DB_BUTTON_ENABLED = "openDbButton.enabled";
    public static final String BINDING_UPGRADE_DB_BUTTON_ENABLED = "upgradeDbButton.enabled";
    public static final String BINDING_WITH_DB_ACTIONS_VISIBLE = "withDbActions.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XS28cRRBub+Ld+J34hUOc+BUla0HGRhyCZAhx1ra80TpBfkhRfAg9O21vh9meoac3nrAy4ifwE+DOBYkbJ8SBMwcuKPwEhDhwRVTPc2d2HmtsH0be6vqqqr+a+rrnuz9Rv8XRwkts2wpvMUGbRHm8/uzZU/UlqYsNYtU5NYXBkfvXV0CFQzSkBXZLoKXDmoSvePCVitE0DUZYB3qthgYt8VonVoMQIdDNKKJuWSt7wfKabba4HzUoKinqN3//Vfha++rbAkK2CdWNwVbm81DhTi7XUIFqAo1Dpld4RcfsGMrglB1DvSPSVtGxZT3BTfI5+hKVaqhoYg7BBFrsfctODAdvmwJd09QdzPAx4fuG+QlmRBdo9Ygr9IiTJuGKaAlBlRZVrBOoQ6kbTEBYRVOVDR94UDVNJ2BRoFIDM00nXKD7Zw2y7SLDWP1NQ5PllNMj7cufB9WKDGiLEFpUufGZrGI5B7tNdPOR4xuCr1J2ZPAmFtRgNazKEsYl+bYHfOwYpfNAgBmqw4YI9wiMujvGmDszNtT1uszgmN6Wj5lgeYwyS2Bd31AfQZGwOTQRiehapfONADNKoeVc+BBpnYt6jJxQ0chKO2yYhHUFWAzLapnHHGskw2WU2IlVhB7Trsc60yo6wVnpRuq6YSUm4+hGZKpgXpVwXsOB6jtE/bwFZoFmDrtHfBeW3OGeiQ23DOis/js98duPb37Y6pzoqUTXDkGCSTM5cMkFlanH3HFuCaqv7GBz7RANWEQHNXPUajahsD1vGYqDfNckXJFwZRtbDQjRX/r9p5+nP/31EipsoUHdwNoWlv5VNCAaHFgwdM02P37oVDR8cgWeV2VtMFMvGvDGAx3tRXccgvFX5MLiqQ1szCawEZSkDvzyz8Te9w99Rvqgwuup7iEr/c9RkTKdMuKonCdgiao2ZFqkpRmhUCVJF0rSLtOb4ved5/0uBi7BJDUMTr+AmcL6uk6PWdPRz7G2O9VKZfPJ/ubuqUCXpaII9KDtKZrSMjUsyA6xLMhYdrRJodaGumlTS5SX350PTTXoCNHKy8sQZxA781aVooeGOqTFbska1xwK5X8foQTpydsQtLT0ilpU1eG9n2wvdJV1mpSmU37yMhQDKubjb4y7MyUQq9hmB72FexqsDL9w0G5Sgd5qV32Ua1LqsrfA1zB97wO2w0jTYLQOAp6XVGkGvkPCMPR9au475d7ORQo4GIOJWO6eiC6APyLdjMYVu3dW59KyenIeI3XAtSdxOt2uephsSss5GVMZXcoDRggtpxPq+6fzGTvNzjQGE+3epiB6HualKEEKwjBkgBvaVOek+dMeisbNlI2752usoyVpTernZPup45/dzTuZuVJ7uZANi3TyTmonPe/0PkauFGeieLKdxXCaFgU3lBjJ46563+PkiMgbM8V6F99z7QPHaTf0+X/aFBRxZm0KkT1qUwjI0KbYte0C23ArpSzv5hZrwhXHnPSqT7UrLiKb8LvZ6VLpTmPPx0XIvptKtu+eTnX0ynqBRKedEv51O35KuPbkU2LTPs8p4Wc88ykRAHs8JQL/jFMi+rVxgXynvWnxj5feeb/l8R5is/lf7bGC1D6802uASD9Wc/rRgUvvS8o3Xg+neFHHrw1wRqMfghTjeZUyDT55H3Rl6ZPPwdyI0vxGPv5IjnD93BFmzx1hCSL8B8PQqEf4EgAA";
    private static final Log log = LogFactory.getLog(DbManagerUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JPanel centerPanel;
    protected JButton closeDbButton;
    protected DbManagerUI dbManagerTopPanel = this;
    protected JButton exportAndCleanDbButton;
    protected JButton exportDbButton;
    protected DbManagerUIHandler handler;
    protected JButton importDbButton;
    protected JLabel informationLabel;
    protected JButton installDbButton;
    protected TuttiUIContext model;
    protected JPanel noDbActions;
    protected JButton openDbButton;
    protected JButton upgradeDbButton;
    protected JPanel withDbActions;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DbManagerUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                DbManagerUIHandler handler = new DbManagerUIHandler(parentUI.getHandler().getContext(), this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public DbManagerUI() {
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JPanel getCenterPanel() {
        return centerPanel;
    }

    public JButton getCloseDbButton() {
        return closeDbButton;
    }

    public JButton getExportAndCleanDbButton() {
        return exportAndCleanDbButton;
    }

    public JButton getExportDbButton() {
        return exportDbButton;
    }

    public DbManagerUIHandler getHandler() {
        return handler;
    }

    public JButton getImportDbButton() {
        return importDbButton;
    }

    public JLabel getInformationLabel() {
        return informationLabel;
    }

    public JButton getInstallDbButton() {
        return installDbButton;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JPanel getNoDbActions() {
        return noDbActions;
    }

    public JButton getOpenDbButton() {
        return openDbButton;
    }

    public JButton getUpgradeDbButton() {
        return upgradeDbButton;
    }

    public JPanel getWithDbActions() {
        return withDbActions;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCenterPanel() {
        if (!allComponentsCreated) {
            return;
        }
        centerPanel.add(noDbActions, BorderLayout.CENTER);
        centerPanel.add(withDbActions, BorderLayout.SOUTH);
    }

    protected void addChildrenToDbManagerTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(informationLabel, BorderLayout.CENTER);
        add(centerPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToNoDbActions() {
        if (!allComponentsCreated) {
            return;
        }
        noDbActions.add(installDbButton);
        noDbActions.add(importDbButton);
    }

    protected void addChildrenToWithDbActions() {
        if (!allComponentsCreated) {
            return;
        }
        withDbActions.add(openDbButton);
        withDbActions.add(upgradeDbButton);
        withDbActions.add(exportDbButton);
        withDbActions.add(exportAndCleanDbButton);
        withDbActions.add(closeDbButton);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.dbManager.help"));
    }

    protected void createCenterPanel() {
        $objectMap.put("centerPanel", centerPanel = new JPanel());
        
        centerPanel.setName("centerPanel");
        centerPanel.setLayout(new BorderLayout());
    }

    protected void createCloseDbButton() {
        $objectMap.put("closeDbButton", closeDbButton = new JButton());
        
        closeDbButton.setName("closeDbButton");
        closeDbButton.setText(_("tutti.dbManager.action.closeDb"));
        closeDbButton.setToolTipText(_("tutti.dbManager.action.closeDb.tip"));
        closeDbButton.putClientProperty("help", "tutti.dbManager.action.closeDb.help");
        closeDbButton.putClientProperty("tuttiAction", CloseDbAction.class);
    }

    protected void createExportAndCleanDbButton() {
        $objectMap.put("exportAndCleanDbButton", exportAndCleanDbButton = new JButton());
        
        exportAndCleanDbButton.setName("exportAndCleanDbButton");
        exportAndCleanDbButton.setText(_("tutti.dbManager.action.exportAndCleanDb"));
        exportAndCleanDbButton.setToolTipText(_("tutti.dbManager.action.exportAndCleanDb.tip"));
        exportAndCleanDbButton.putClientProperty("help", "tutti.dbManager.action.exportAndCleanDb.help");
        exportAndCleanDbButton.putClientProperty("tuttiAction", ExportAndCleanDbAction.class);
    }

    protected void createExportDbButton() {
        $objectMap.put("exportDbButton", exportDbButton = new JButton());
        
        exportDbButton.setName("exportDbButton");
        exportDbButton.setText(_("tutti.dbManager.action.exportDb"));
        exportDbButton.setToolTipText(_("tutti.dbManager.action.exportDb.tip"));
        exportDbButton.putClientProperty("help", "tutti.dbManager.action.exportDb.help");
        exportDbButton.putClientProperty("tuttiAction", ExportDbAction.class);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(DbManagerUIHandler.class));
    }

    protected void createImportDbButton() {
        $objectMap.put("importDbButton", importDbButton = new JButton());
        
        importDbButton.setName("importDbButton");
        importDbButton.setText(_("tutti.dbManager.action.importDb"));
        importDbButton.setToolTipText(_("tutti.dbManager.action.importDb.tip"));
        importDbButton.putClientProperty("help", "tutti.dbManager.action.importDb.help");
        importDbButton.putClientProperty("tuttiAction", ImportDbAction.class);
    }

    protected void createInformationLabel() {
        $objectMap.put("informationLabel", informationLabel = new JLabel());
        
        informationLabel.setName("informationLabel");
    }

    protected void createInstallDbButton() {
        $objectMap.put("installDbButton", installDbButton = new JButton());
        
        installDbButton.setName("installDbButton");
        installDbButton.setText(_("tutti.dbManager.action.installDb"));
        installDbButton.setToolTipText(_("tutti.dbManager.action.installDb.tip"));
        installDbButton.putClientProperty("help", "tutti.dbManager.action.installDb.help");
        installDbButton.putClientProperty("tuttiAction", InstallDbAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createNoDbActions() {
        $objectMap.put("noDbActions", noDbActions = new JPanel());
        
        noDbActions.setName("noDbActions");
        noDbActions.setLayout(new GridLayout(0, 1));
    }

    protected void createOpenDbButton() {
        $objectMap.put("openDbButton", openDbButton = new JButton());
        
        openDbButton.setName("openDbButton");
        openDbButton.setText(_("tutti.dbManager.action.openDb"));
        openDbButton.setToolTipText(_("tutti.dbManager.action.openDb.tip"));
        openDbButton.putClientProperty("help", "tutti.dbManager.action.openDb.help");
        openDbButton.putClientProperty("tuttiAction", OpenDbAction.class);
    }

    protected void createUpgradeDbButton() {
        $objectMap.put("upgradeDbButton", upgradeDbButton = new JButton());
        
        upgradeDbButton.setName("upgradeDbButton");
        upgradeDbButton.setText(_("tutti.dbManager.action.upgradeDb"));
        upgradeDbButton.setToolTipText(_("tutti.dbManager.action.upgradeDb.tip"));
        upgradeDbButton.putClientProperty("help", "tutti.dbManager.action.upgradeDb.help");
        upgradeDbButton.putClientProperty("tuttiAction", UpdateReferentialAction.class);
    }

    protected void createWithDbActions() {
        $objectMap.put("withDbActions", withDbActions = new JPanel());
        
        withDbActions.setName("withDbActions");
        withDbActions.setLayout(new GridLayout(0, 1));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDbManagerTopPanel();
        addChildrenToCenterPanel();
        addChildrenToNoDbActions();
        addChildrenToWithDbActions();
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 20 property setters
        informationLabel.setHorizontalAlignment(JLabel.CENTER);
        informationLabel.setIcon(SwingUtil.createActionIcon("information"));
        installDbButton.setIcon(SwingUtil.createActionIcon("install-db"));
        installDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.installDb.mnemonic"),'Z'));
        importDbButton.setIcon(SwingUtil.createActionIcon("import-db"));
        importDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.importDb.mnemonic"),'Z'));
        openDbButton.setIcon(SwingUtil.createActionIcon("open-db"));
        openDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.openDb.mnemonic"),'Z'));
        upgradeDbButton.setIcon(SwingUtil.createActionIcon("update-referential"));
        upgradeDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.upgradeDb.mnemonic"),'Z'));
        exportDbButton.setIcon(SwingUtil.createActionIcon("export-db"));
        exportDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.exportDb.mnemonic"),'Z'));
        exportAndCleanDbButton.setIcon(SwingUtil.createActionIcon("export-db"));
        exportAndCleanDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.exportAndCleanDb.mnemonic"),'Z'));
        closeDbButton.setIcon(SwingUtil.createActionIcon("close-db"));
        closeDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.closeDb.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, dbManagerTopPanel, "tutti.dbManager.help");
        registerHelpId(_broker, installDbButton, "tutti.dbManager.action.installDb.help");
        registerHelpId(_broker, importDbButton, "tutti.dbManager.action.importDb.help");
        registerHelpId(_broker, openDbButton, "tutti.dbManager.action.openDb.help");
        registerHelpId(_broker, upgradeDbButton, "tutti.dbManager.action.upgradeDb.help");
        registerHelpId(_broker, exportDbButton, "tutti.dbManager.action.exportDb.help");
        registerHelpId(_broker, exportAndCleanDbButton, "tutti.dbManager.action.exportAndCleanDb.help");
        registerHelpId(_broker, closeDbButton, "tutti.dbManager.action.closeDb.help");
        _broker.prepareUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("dbManagerTopPanel", dbManagerTopPanel);
        createHandler();
        createModel();
        createBroker();
        createInformationLabel();
        createCenterPanel();
        createNoDbActions();
        createInstallDbButton();
        createImportDbButton();
        createWithDbActions();
        createOpenDbButton();
        createUpgradeDbButton();
        createExportDbButton();
        createExportAndCleanDbButton();
        createCloseDbButton();
        // inline creation of dbManagerTopPanel
        setName("dbManagerTopPanel");
        setLayout(new BorderLayout());
        dbManagerTopPanel.putClientProperty("help", "tutti.dbManager.help");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INFORMATION_LABEL_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    informationLabel.setText(_(handler.updateMessage(model.isDbExist(), model.isDbLoaded())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NO_DB_ACTIONS_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    noDbActions.setVisible(!model.isDbExist());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WITH_DB_ACTIONS_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    withDbActions.setVisible(model.isDbExist());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OPEN_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    openDbButton.setEnabled(!model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UPGRADE_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    upgradeDbButton.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportDbButton.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_AND_CLEAN_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportAndCleanDbButton.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLOSE_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    closeDbButton.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
    }

}