package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportProtocolAction.java 630 2013-03-15 10:20:17Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/home/ImportProtocolAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * Opens a file chooser and imports the protocol from the selected file.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ImportProtocolAction extends AbstractChangeScreenAction {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ImportProtocolAction.class);

    public static final JAXXContextEntryDef<TuttiProtocol> IMPORT_PROTOCOL_ENTRY = new JAXXContextEntryDef<TuttiProtocol>("importProtocol", TuttiProtocol.class);

    private File file;

    public ImportProtocolAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.EDIT_PROTOCOL);
    }

    @Override
    protected boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {
            // choose file to import
            file = TuttiUIUtil.chooseFile(
                    getContext().getMainUI(),
                    _("tutti.selectCruise.title.choose.importFile"),
                    _("tutti.selectCruise.action.chooseProtocolFile"),
                    "^.+\\.tuttiProtocol$", _("tutti.common.file.protocol")
            );

            doAction = file != null;
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull(file);

        if (log.isInfoEnabled()) {
            log.info("Will import protocol file: " + file);
        }

        // import protocol
        TuttiProtocolImportExportService service =
                getContext().getTuttiProtocolImportExportService();
        TuttiProtocol protocol = service.importProtocol(file);

        sendMessage("Protocole [" + protocol.getName() + "] lu depuis le fichier.");

        // store protocol in context
        IMPORT_PROTOCOL_ENTRY.setContextValue(getContext().getMainUI(), protocol);

        // remove id
        protocol.setId(null);

        // removed selected protocol
        getContext().setProtocolId(null);
        super.doAction();
    }
}
