/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.config;

import fr.ifremer.tutti.service.config.TuttiServiceConfigOption;
import fr.ifremer.tutti.ui.swing.MainUI;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfigOption;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.Icon;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.config.ConfigUI;
import jaxx.runtime.swing.editor.config.ConfigUIHelper;
import jaxx.runtime.swing.editor.config.model.CallBackFinalizer;
import jaxx.runtime.swing.editor.config.model.MainCallBackFinalizer;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;

public class TuttiConfigUI {
    public static final String CALLBACK_APPLICATION = "application";
    public static final String CALLBACK_UI = "ui";
    public static final String CALLBACK_SHORTCUT = "shortcut";
    protected final MainUI mainUI;

    public TuttiConfigUI(MainUI mainUI) {
        this.mainUI = mainUI;
    }

    public void createUI() {
        TuttiApplicationConfig config = this.mainUI.getHandler().getContext().getConfig();
        ConfigUIHelper helper = new ConfigUIHelper(config.getApplicationConfig());
        helper.registerCallBack(CALLBACK_UI, I18n.n_((String)"tutti.action.reload.ui", (Object[])new Object[0]), (Icon)SwingUtil.createActionIcon((String)"reload-ui"), new Runnable(){

            @Override
            public void run() {
                TuttiConfigUI.this.reloadUI();
            }
        }).registerCallBack(CALLBACK_APPLICATION, I18n.n_((String)"tutti.action.reload.application", (Object[])new Object[0]), (Icon)SwingUtil.createActionIcon((String)"reload-application"), new Runnable(){

            @Override
            public void run() {
                TuttiConfigUI.this.reloadApplication();
            }
        }).registerCallBack(CALLBACK_SHORTCUT, I18n.n_((String)"tutti.action.reload.actions", (Object[])new Object[0]), (Icon)SwingUtil.createActionIcon((String)"reload-shortcut"), new Runnable(){

            @Override
            public void run() {
                TuttiConfigUI.this.reloadShortcuts();
            }
        });
        helper.addCategory(I18n.n_((String)"tutti.config.category.applications", (Object[])new Object[0]), I18n.n_((String)"tutti.config.category.applications.description", (Object[])new Object[0]), CALLBACK_APPLICATION).addOption((ApplicationConfig.OptionDef)TuttiServiceConfigOption.DATA_DIRECTORY).addOption((ApplicationConfig.OptionDef)TuttiServiceConfigOption.SITE_URL).addOption((ApplicationConfig.OptionDef)TuttiApplicationConfigOption.UI_CONFIG_FILE);
        helper.addCategory(I18n.n_((String)"tutti.config.category.ui", (Object[])new Object[0]), I18n.n_((String)"tutti.config.category.ui.description", (Object[])new Object[0]), CALLBACK_UI).addOption((ApplicationConfig.OptionDef)TuttiApplicationConfigOption.COLOR_ROW_INVALID).addOption((ApplicationConfig.OptionDef)TuttiApplicationConfigOption.COLOR_ROW_READ_ONLY).addOption((ApplicationConfig.OptionDef)TuttiApplicationConfigOption.COLOR_CELL_WITH_VALUE).addOption((ApplicationConfig.OptionDef)TuttiApplicationConfigOption.COLOR_ROW_TO_CONFIRM).addOption((ApplicationConfig.OptionDef)TuttiApplicationConfigOption.DATE_FORMAT).addOption((ApplicationConfig.OptionDef)TuttiApplicationConfigOption.COORDINATE_EDITOR_TYPE);
        helper.addCategory(I18n.n_((String)"tutti.config.category.shortcuts", (Object[])new Object[0]), I18n.n_((String)"tutti.config.category.shortcuts.description", (Object[])new Object[0]), CALLBACK_SHORTCUT).addOption((ApplicationConfig.OptionDef)TuttiApplicationConfigOption.SHORTCUT_CLOSE_POPUP);
        helper.setFinalizer((CallBackFinalizer)new MainCallBackFinalizer(CALLBACK_APPLICATION));
        ConfigUI configUI = helper.buildUI((JAXXContext)this.mainUI, "tutti.config.category.applications");
        helper.displayUI((Frame)this.mainUI, false);
        this.mainUI.getHandler().getContext().getSwingSession().add((Component)configUI);
    }

    protected void reloadApplication() {
        this.mainUI.getHandler().reloadApplication();
    }

    protected void reloadUI() {
        this.mainUI.getHandler().reloadTutti();
    }

    protected void reloadShortcuts() {
        this.mainUI.getHandler().reloadShortcuts();
    }
}

