/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.MainUI;
import fr.ifremer.tutti.ui.swing.MainUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import java.awt.event.ActionEvent;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationUpdater;

public class UpdateApplicationAction
extends AbstractTuttiAction<TuttiUIContext, MainUI, MainUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UpdateApplicationAction.class);

    public UpdateApplicationAction(MainUIHandler handler) {
        super(handler, "updateApplication", "update-application", I18n._((String)"tutti.action.updateApplication", (Object[])new Object[0]), I18n._((String)"tutti.action.updateApplication.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected void doAction(ActionEvent event) {
        TuttiApplicationConfig config = this.getContext().getConfig();
        File current = config.getTuttiBasedir();
        if (current == null || !current.exists()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No application base directory defined, skip updates.");
            }
        } else {
            String url = config.getUpdateUrl();
            File dest = new File(config.getTuttiBasedir(), "NEW");
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Try to update jre, i18N or tutti (current application location: %s), using update url: %s", current, url));
            }
            ApplicationUpdater up = new ApplicationUpdater();
            ProgressionModel progressionModel = new ProgressionModel();
            this.getContext().getActionUI().getModel().setProgressionModel(progressionModel);
            progressionModel.setMessage("Recherche de mises \u00e0 jour de JRE / Tutti / I18N");
            TuttiApplicationUpdaterCallBack callback = new TuttiApplicationUpdaterCallBack(this.getContext(), progressionModel);
            callback.setTypes(TuttiApplicationUpdaterCallBack.UpdateType.JRE, TuttiApplicationUpdaterCallBack.UpdateType.I18N, TuttiApplicationUpdaterCallBack.UpdateType.TUTTI);
            up.update(url, current, dest, false, (ApplicationUpdater.ApplicationUpdaterCallback)callback);
            this.getContext().getActionUI().getModel().setProgressionModel(null);
        }
    }
}

