/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import fr.ifremer.tutti.persistence.RessourceClassLoader;
import fr.ifremer.tutti.service.TuttiService;
import fr.ifremer.tutti.service.TuttiTechnicalException;
import fr.ifremer.tutti.service.config.TuttiServiceConfig;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TuttiServiceContext
implements Closeable {
    private static final Log log = LogFactory.getLog(TuttiServiceContext.class);
    protected final TuttiServiceConfig config;
    protected final RessourceClassLoader resourceLoader;
    protected final LoadingCache<Class<? extends TuttiService>, TuttiService> services;

    public TuttiServiceContext(RessourceClassLoader resourceLoader, TuttiServiceConfig config) {
        this.resourceLoader = resourceLoader;
        this.config = config;
        this.services = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class<? extends TuttiService>, TuttiService>(){

            public TuttiService load(Class<? extends TuttiService> key) throws Exception {
                Preconditions.checkNotNull(key);
                Constructor<? extends TuttiService> constructor = key.getConstructor(new Class[0]);
                Preconditions.checkNotNull(constructor);
                TuttiService service = constructor.newInstance(new Object[0]);
                if (log.isInfoEnabled()) {
                    log.info((Object)("New service " + service));
                }
                service.setServiceContext(TuttiServiceContext.this);
                return service;
            }
        });
    }

    public TuttiServiceConfig getConfig() {
        return this.config;
    }

    public RessourceClassLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public <S extends TuttiService> S getService(Class<S> serviceType) {
        try {
            TuttiService s = (TuttiService)this.services.get(serviceType);
            return (S)s;
        }
        catch (ExecutionException e) {
            throw new TuttiTechnicalException("Could not instanciate service " + serviceType, e);
        }
    }

    @Override
    public void close() throws IOException {
        for (TuttiService service : this.services.asMap().values()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Close service " + service));
            }
            IOUtils.closeQuietly((Closeable)service);
        }
        this.services.invalidateAll();
    }
}

