package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id: FishingOperationsUIHandler.java 407 2013-02-12 18:40:17Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/FishingOperationsUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JTabbedPane;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

/**
 * Handler of UI {@link FishingOperationsUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class FishingOperationsUIHandler extends AbstractTuttiTabContainerUIHandler<FishingOperationsUIModel, FishingOperationsUI> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(FishingOperationsUIHandler.class);

    private final PersistenceService persistenceService;

    protected EditFishingOperationAction editFishingOperationAction;

    public FishingOperationsUIHandler(TuttiUI parentUI,
                                      FishingOperationsUI ui) {
        super(parentUI.getHandler().getContext(), ui);
        persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {

        if (log.isInfoEnabled()) {
            log.info("for " + ui);
        }
        FishingOperationsUIModel model = new FishingOperationsUIModel();

        EditCatchesUIModel catchesUIModel = new EditCatchesUIModel();

        String cruiseId = context.getCruiseId();

        // load existing cruise
        Cruise cruise = persistenceService.getCruise(cruiseId);

        // store it in context
        TuttiUIUtil.setCruise(context, cruise);
        TuttiUIUtil.setProgram(context, cruise.getProgram());

        TuttiProtocol protocol;
        if (getContext().isProtocolFilled()) {

            // load existing protocol

            protocol = persistenceService.getProtocol(
                    getContext().getProtocolId());

            if (log.isInfoEnabled()) {
                log.info("Loading existing protocol: " + protocol);
            }
        } else {

            // remove any previous existing protocol
            protocol = null;
        }

        TuttiUIUtil.setProtocol(context, protocol);

        List<FishingOperation> fishingOperations =
                persistenceService.getAllFishingOperation(cruiseId);

        //FIXME Should remove this when no more use dev persistence impl
        //TODO make sure to use selection cruise ?
        for (FishingOperation fishingOperation : fishingOperations) {
            fishingOperation.setCruise(cruise);
        }
        model.setFishingOperation(fishingOperations);

        if (log.isInfoEnabled()) {
            log.info("Loaded " + fishingOperations.size() +
                     " fishingOperation(s).");
        }

        ui.setContextValue(model);
        ui.setContextValue(catchesUIModel);
    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        editFishingOperationAction =
                createAction(EditFishingOperationAction.class);

        FishingOperationsUIModel model = getModel();

        List<FishingOperation> fishingOperations = model.getFishingOperation();

        initBeanComboBox(ui.getFishingOperationComboBox(),
                         fishingOperations,
                         model.getSelectedFishingOperation());

        model.addPropertyChangeListener(FishingOperationsUIModel.PROPERTY_SELECTED_FISHING_OPERATION, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("propertyChange " + FishingOperationsUIModel.PROPERTY_SELECTED_FISHING_OPERATION);
                }

                if (!getModel().isEditionAdjusting()) {

                    // selected fishing operation is now the editing one

                    FishingOperation newValue = (FishingOperation) evt.getNewValue();

                    FishingOperation operation;
                    if (newValue == null) {
                        operation = null;
                    } else {
                        operation = persistenceService.getFishingOperation(newValue.getId());
                    }
                    editFishingOperationAction.setFishingOperation(operation);
                    editFishingOperationAction.actionPerformed(null);
//                    getModel().setEditFishingOperation(operation);
                }
            }
        });

//        model.addPropertyChangeListener(FishingOperationsUIModel.PROPERTY_EDITED_FISHING_OPERATION, new PropertyChangeListener() {
//            @Override
//            public void propertyChange(PropertyChangeEvent evt) {
//                if (log.isDebugEnabled()) {
//                    log.debug("propertyChange " + FishingOperationsUIModel.PROPERTY_EDITED_FISHING_OPERATION);
//                }
//
//                // only rebuild stuff if model is not adjusting
//                editFishingOperationAction.setFishingOperation((FishingOperation) evt.getNewValue());
//                editFishingOperationAction.actionPerformed(null);
//
//            }
//        });
        model.addPropertyChangeListener(FishingOperationsUIModel.PROPERTY_FISHING_OPERATION, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("propertyChange " + FishingOperationsUIModel.PROPERTY_FISHING_OPERATION);
                }
                ui.getFishingOperationComboBox().setData(null);
                ui.getFishingOperationComboBox().setData((List<FishingOperation>) evt.getNewValue());
            }
        });

        if (!fishingOperations.isEmpty()) {

            model.setSelectedFishingOperation(fishingOperations.get(0));
        }
    }

    @Override
    public void onCloseUI() {

        // ui will be saved so we do not want to keep selected tab indexes
        ui.getTabPane().setSelectedIndex(0);
        ui.getFishingOperationTabContent().getFishingOperationTabPane().setSelectedIndex(0);

        closeUI(ui.getFishingOperationTabContent());
        closeUI(ui.getCatchesTabContent());
    }

    @Override
    public boolean canCloseUI(TuttiScreen nextScreen) {
//        boolean result = super.canCloseUI(nextScreen);
        // try to reset current fishing operation, if afterall the fishing operation still
        // there, it means user cancel save operation, so stay here
        getUI().getFishingOperationComboBox().setSelectedItem(null);
//        getModel().setSelectedFishingOperation(null);
        boolean result = getModel().getSelectedFishingOperation() == null;
//        if (getTabPanel().getSelectedIndex() == 0) {
//            result = ui.getFishingOperationTabContent().getHandler().canCloseUI(nextScreen);
//        }
        return result;
    }

    @Override
    public SwingValidator<FishingOperationsUIModel> getValidator() {
        return null;
    }

    @Override
    public JTabbedPane getTabPanel() {
        return ui.getTabPane();
    }

    public boolean isFishingOperationModified() {
        return getModel().getEditFishingOperation() != null &&
               getUI().getFishingOperationTabContent().getModel().isModify();
    }

    public boolean isFishingOperationValid() {
        return getModel().getEditFishingOperation() != null &&
               getUI().getFishingOperationTabContent().getModel().isValid();
    }

    public boolean isCatchBatchModified() {
        return getModel().getEditFishingOperation() != null &&
               getUI().getCatchesTabContent().getModel().isModify();
    }

    public boolean isCatchBatchValid() {
        return getModel().getEditFishingOperation() != null &&
               getUI().getCatchesTabContent().getModel().isValid();
    }
}
