package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.ActionListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SelectCruiseUI extends JPanel implements TuttiUI<SelectCruiseUIModel, SelectCruiseUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CRUISE_COMBOBOX_ENABLED = "cruiseCombobox.enabled";
    public static final String BINDING_CRUISE_COMBOBOX_SELECTED_ITEM = "cruiseCombobox.selectedItem";
    public static final String BINDING_EDIT_CATCHES_BUTTON_ENABLED = "editCatchesButton.enabled";
    public static final String BINDING_EDIT_CRUISE_BUTTON_ENABLED = "editCruiseButton.enabled";
    public static final String BINDING_EDIT_PROGRAM_BUTTON_ENABLED = "editProgramButton.enabled";
    public static final String BINDING_EDIT_PROTOCOL_COMBO_BOX_ENABLED = "editProtocolComboBox.enabled";
    public static final String BINDING_NEW_CRUISE_BUTTON_ENABLED = "newCruiseButton.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_ENABLED = "programCombobox.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM = "programCombobox.selectedItem";
    public static final String BINDING_PROTOCOL_COMBOBOX_ENABLED = "protocolCombobox.enabled";
    public static final String BINDING_PROTOCOL_COMBOBOX_SELECTED_ITEM = "protocolCombobox.selectedItem";
    public static final String BINDING_VALIDATE_CATCHES_BUTTON_ENABLED = "validateCatchesButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAL1XzW8bRRSfuPlykjZpnLSOmoDTVlERYd2AgIpE/YibqI7sECVtqcgB1t5JPNV6d5mdbTayijhz4k+AOxckbpwQB84cuCDO9AJCHLgi3szst9dfjSBSVsnMe7/3ex/z3szXf6ARm6Llp6rrKtQxGGliZefekyfv157iOruP7TolFjMpkj9DGZQ5RJNasG4zdO2wwtWLnnqxZDYt08BGRHu9giZsdqpju4ExY2gprlG37eJBsL3uWg71UQNSaahf/vVn5gvts68yCLkWsMuDK4VeWqEnwxWUIRpDs2DpmVrUVeMYaFBiHAPf83ytpKu2vas28SfoUzRWQaOWSgGMoav9uywwhL5rMZRtmE28pxpYZ+jtI6qQI4qbmCrMYYwoDlHsE7Cv1E2DAZzCpZUDrEMuStQhNn5UtiyBNsrQWEM1NB1ThjZeCumBVA8BR5qmxom991JwVa4cgk1jSk36UK3puCphN2KpeabqRFMhUh7yAf8+9her2LbVYxyqh8DZQJOh1weAjATuusC9yVA+pi+1xB6XzAYKUxY1j6narKg17sgsrw3XE98Ri1wwH/ruyUNd1Mya6SaJSk2sEc61hlVD2YSPkN403TjW+PUdUS83k3bFalz2Iofck7Y3IXGQLJSLKclVLr4caM0Y+CSmxNdX4jKTdZHlwNeluOELctv3l68W0t1Y4/9fi+/NcNqyjBIE3ghDCiR7iJyHqDOzbuqdWM74An3wfDOF55wX3hBjk+d2PhbhaBbfDVRzMsYxTb61Hhfzrb+VYl0kt6SyegPbiRjcDoTmvTOAOwpSdCVWi9B8lbD5ht1x6BCNUAeW4ZQctvfrfdiSnTqf6NQcUOz+cyn383e/frvtt+fLYHs+VTQyXaBtQpYs6GqEm56WvdlhRC9WVWv9EGVt0XXE6FlMIXbgbQM5sHeRqytcXXmg2g2AGBn75fsfLn380zmU2UYTuqlq2yqXL6Msa1CIgqlrrnXnrmA0dTIO3xn4PcfQMD+p0D1aok0+Z2iCrN0y9ig+IlAF07JTeuRPFWhUgHWyj20+8YYZdbAL0VpMiVZAuZb98e/cwTd3/YgNgQcLHcXDqI18iEaJoRMDi5HmTavUETZp2djRzHAqpc0pBJNqKtqSvN5ZFt9qW3Ay3EHsgp85GQWdn0DF64IQKIgwMY0ynx5ozFt2HQ72SLjJ//oAJRqt1cPqMGBhg3drGOKLreVE01WIvdW02OmN1yBVU7JqsFZmGAjNyRwqx9hvl0JqnGf44akF52C65W0odR4YvumntrsLyd7fy4tM1Iu8x4vYnvVt0zE06cFHIrT3RCQZWmhthb1eLnpM00i1D4ZetIbaLOZbu8Gc6Gmwbab0sgfna1xUzTaf6zOt+EB5HhTYbLTApFCivkblahqr6BTrg1CYlyut5TihbsWVC4tLTixZW2H5dGGYGKQDFc9ah+IprKwU/B1JqGNV5UVVSaHeOU6O7f+o1C/zwuuTU/KaMFjZzbaSN4Sw8OYSnU2IJUpv3F9Poxa/ngxUfkuiucWIdSvA+Vh3E2rJEuzKtO2e1Edi/bfDfst7lSg8E1xf5kxc4m/shregaCpXC2V4QFGWtieIw6tLw5Q/dV5pAW5BClSIzUpY1/e9XXAyzZ20u9dA4V+IlqqACWvV9/vzrn5vRS6OccdLOjwc07e23E4xWS3ch4SzVL2zxyv1mjvQ2S4GAROvL9mCHFLij0eXhW2I6CDeebp5d9j+plvswvv/sl1qPY7funsyTr+m9zGTR3X11ARhdGED1NVCjRgaPDtutxkZ4t+JPhCDOw+XeJGO82pPHL78WxeEq30h/N4FYfXMHJQzc3jnzBxunRnhDiD8C4Mtpam3EwAA";
    private static final Log log = LogFactory.getLog(SelectCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator",  propertyName = "cruise",  editorName = "cruiseCombobox")
    protected BeanComboBox<Cruise> cruiseCombobox;
    protected JLabel cruiseLabel;
    protected JButton editCatchesButton;
    protected JButton editCruiseButton;
    protected JButton editProgramButton;
    protected JComboBox editProtocolComboBox;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected SelectCruiseUIHandler handler;
    protected SelectCruiseUI homePanel = this;
    protected SelectCruiseUIModel model;
    protected JButton newCruiseButton;
    protected JButton newProgramButton;
    protected JComboBox newProtocolComboBox;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "programCombobox")
    protected BeanComboBox<Program> programCombobox;
    protected JLabel programLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "protocol",  editorName = "protocolCombobox")
    protected BeanComboBox<TuttiProtocol> protocolCombobox;
    protected JLabel protocolLabel;
    protected JButton validateCatchesButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<SelectCruiseUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiUIContext uiContext;
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectCruiseUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                uiContext = parentUI.getHandler().getContext();
                SelectCruiseUIHandler handler =
                                     new SelectCruiseUIHandler(parentUI, this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public SelectCruiseUI() {
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__editProtocolComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startExistingProtocolAction(event);
    }

    public void doActionPerformed__on__newProtocolComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startNewProtocolAction(event);
    }

    public void doMouseEntered__on__editProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProtocolComboBox.isEnabled()) { editProtocolComboBox.showPopup(); }
    }

    public void doMouseEntered__on__newProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        newProtocolComboBox.showPopup();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanComboBox<Cruise> getCruiseCombobox() {
        return cruiseCombobox;
    }

    public JLabel getCruiseLabel() {
        return cruiseLabel;
    }

    public JButton getEditCatchesButton() {
        return editCatchesButton;
    }

    public JButton getEditCruiseButton() {
        return editCruiseButton;
    }

    public JButton getEditProgramButton() {
        return editProgramButton;
    }

    public JComboBox getEditProtocolComboBox() {
        return editProtocolComboBox;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public SelectCruiseUIHandler getHandler() {
        return handler;
    }

    public SelectCruiseUIModel getModel() {
        return model;
    }

    public JButton getNewCruiseButton() {
        return newCruiseButton;
    }

    public JButton getNewProgramButton() {
        return newProgramButton;
    }

    public JComboBox getNewProtocolComboBox() {
        return newProtocolComboBox;
    }

    public BeanComboBox<Program> getProgramCombobox() {
        return programCombobox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public BeanComboBox<TuttiProtocol> getProtocolCombobox() {
        return protocolCombobox;
    }

    public JLabel getProtocolLabel() {
        return protocolLabel;
    }

    public JButton getValidateCatchesButton() {
        return validateCatchesButton;
    }

    public SwingValidator<SelectCruiseUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createCruiseCombobox() {
        $objectMap.put("cruiseCombobox", cruiseCombobox = new BeanComboBox<Cruise>(this));
        
        cruiseCombobox.setName("cruiseCombobox");
        cruiseCombobox.setI18nPrefix("tutti.property.");
        cruiseCombobox.setProperty("cruise");
        cruiseCombobox.setShowReset(true);
    }

    protected void createCruiseLabel() {
        $objectMap.put("cruiseLabel", cruiseLabel = new JLabel());
        
        cruiseLabel.setName("cruiseLabel");
        cruiseLabel.setText(_("tutti.label.cruise"));
    }

    protected void createEditCatchesButton() {
        $objectMap.put("editCatchesButton", editCatchesButton = new JButton());
        
        editCatchesButton.setName("editCatchesButton");
        editCatchesButton.putClientProperty("tuttiAction", EditCatchesAction.class);
    }

    protected void createEditCruiseButton() {
        $objectMap.put("editCruiseButton", editCruiseButton = new JButton());
        
        editCruiseButton.setName("editCruiseButton");
        editCruiseButton.putClientProperty("tuttiAction", EditCruiseAction.class);
    }

    protected void createEditProgramButton() {
        $objectMap.put("editProgramButton", editProgramButton = new JButton());
        
        editProgramButton.setName("editProgramButton");
        editProgramButton.putClientProperty("tuttiAction", EditProgramAction.class);
    }

    protected void createEditProtocolComboBox() {
        $objectMap.put("editProtocolComboBox", editProtocolComboBox = new JComboBox());
        
        editProtocolComboBox.setName("editProtocolComboBox");
        editProtocolComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editProtocolComboBox"));
        editProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__editProtocolComboBox"));
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SelectCruiseUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SelectCruiseUIModel.class));
    }

    protected void createNewCruiseButton() {
        $objectMap.put("newCruiseButton", newCruiseButton = new JButton());
        
        newCruiseButton.setName("newCruiseButton");
        newCruiseButton.putClientProperty("tuttiAction", NewCruiseAction.class);
    }

    protected void createNewProgramButton() {
        $objectMap.put("newProgramButton", newProgramButton = new JButton());
        
        newProgramButton.setName("newProgramButton");
        newProgramButton.putClientProperty("tuttiAction", NewProgramAction.class);
    }

    protected void createNewProtocolComboBox() {
        $objectMap.put("newProtocolComboBox", newProtocolComboBox = new JComboBox());
        
        newProtocolComboBox.setName("newProtocolComboBox");
        newProtocolComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newProtocolComboBox"));
        newProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__newProtocolComboBox"));
    }

    protected void createProgramCombobox() {
        $objectMap.put("programCombobox", programCombobox = new BeanComboBox<Program>(this));
        
        programCombobox.setName("programCombobox");
        programCombobox.setI18nPrefix("tutti.property.");
        programCombobox.setProperty("program");
        programCombobox.setShowReset(true);
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(_("tutti.label.program"));
    }

    protected void createProtocolCombobox() {
        $objectMap.put("protocolCombobox", protocolCombobox = new BeanComboBox<TuttiProtocol>(this));
        
        protocolCombobox.setName("protocolCombobox");
        protocolCombobox.setI18nPrefix("tutti.property.");
        protocolCombobox.setProperty("protocol");
        protocolCombobox.setShowReset(true);
    }

    protected void createProtocolLabel() {
        $objectMap.put("protocolLabel", protocolLabel = new JLabel());
        
        protocolLabel.setName("protocolLabel");
        protocolLabel.setText(_("tutti.label.protocol"));
    }

    protected void createValidateCatchesButton() {
        $objectMap.put("validateCatchesButton", validateCatchesButton = new JButton());
        
        validateCatchesButton.setName("validateCatchesButton");
        validateCatchesButton.putClientProperty("tuttiAction", ValidateCatchesAction.class);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SelectCruiseUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        // inline complete setup of $Table0
        $Table0.add(programLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(programCombobox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cruiseLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cruiseCombobox), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(protocolLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(protocolCombobox), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(editProgramButton);
        $JPanel0.add(newProgramButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(editCruiseButton);
        $JPanel1.add(newCruiseButton);
        // inline complete setup of $JPanel2
        $JPanel2.add(editProtocolComboBox);
        $JPanel2.add(newProtocolComboBox);
        // inline complete setup of $JPanel3
        $JPanel3.add(editCatchesButton);
        $JPanel3.add(validateCatchesButton);
        
        // apply 12 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 20 property setters
        programCombobox.setBeanType(Program.class);
        cruiseCombobox.setBeanType(Cruise.class);
        protocolCombobox.setBeanType(TuttiProtocol.class);
        programLabel.setIcon(SwingUtil.createActionIcon("program"));
        programCombobox.setBean(model);
        cruiseLabel.setLabelFor(cruiseCombobox);
        cruiseLabel.setIcon(SwingUtil.createActionIcon("cruise"));
        cruiseCombobox.setBean(model);
        protocolLabel.setLabelFor(protocolCombobox);
        protocolLabel.setIcon(SwingUtil.createActionIcon("protocol"));
        protocolCombobox.setBean(model);
        editProtocolComboBox.setModel(handler.newComboActionModel(EditProtocolAction.class, CloneProtocolAction.class, ExportProtocolAction.class, DeleteProtocolAction.class));
        editProtocolComboBox.setRenderer(new ActionListCellRenderer());
        newProtocolComboBox.setModel(handler.newComboActionModel(NewProtocolAction.class, ImportProtocolAction.class));
        newProtocolComboBox.setRenderer(new ActionListCellRenderer());
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createProgramLabel();
        createProgramCombobox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createEditProgramButton();
        createNewProgramButton();
        createCruiseLabel();
        createCruiseCombobox();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createEditCruiseButton();
        createNewCruiseButton();
        createProtocolLabel();
        createProtocolCombobox();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createEditProtocolComboBox();
        createNewProtocolComboBox();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createEditCatchesButton();
        createValidateCatchesButton();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 12 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 12 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (programCombobox != null) {
                    programCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (programCombobox != null) {
                    programCombobox.setEnabled(!programCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (programCombobox != null) {
                    programCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programCombobox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROGRAM_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProgramButton.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.setEnabled(!cruiseCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cruise", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cruiseCombobox.setSelectedItem(model.getCruise());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cruise", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CRUISE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editCruiseButton.setEnabled(model.isProgramFound() && model.isCruiseFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_CRUISE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    newCruiseButton.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROTOCOL_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.setEnabled(!protocolCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROTOCOL_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("protocol", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    protocolCombobox.setSelectedItem(model.getProtocol());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("protocol", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROTOCOL_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("protocolFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProtocolComboBox.setEnabled(model.isProtocolFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("protocolFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                addPropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && uiContext != null) {
                    editCatchesButton.setEnabled(model.isValid() && uiContext.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                removePropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                addPropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && uiContext != null) {
                    validateCatchesButton.setEnabled(model.isValid() && uiContext.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                removePropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
    }

}