package fr.ifremer.tutti.ui.swing;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportTemporaryReferentialAction.java 343 2013-02-06 01:52:42Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/ImportTemporaryReferentialAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.SwingUtilities;
import java.awt.event.ActionEvent;

import static org.nuiton.i18n.I18n._;

/**
 * Open screen to import referential
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ImportTemporaryReferentialAction extends AbstractChangeScreenAction {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ImportTemporaryReferentialAction.class);

    public ImportTemporaryReferentialAction(MainUIHandler handler) {
        super(handler,
              "importTemporaryReferential",
              "temporary-referential-import",
              _("tutti.action.importTemporaryReferential"),
              _("tutti.action.importTemporaryReferential.tip"),
              true
        );
    }

    @Override
    protected void doAction(ActionEvent e) {
        getContext().setScreen(getNextScreen());
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                getContext().getMainUI().getBody().revalidate();
            }
        });

    }

    @Override
    protected TuttiScreen getNextScreen() {
        return TuttiScreen.IMPORT_TEMPORARY_REFERENTIAL;
    }
}
