/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.accidental;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextCellComponent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class AccidentalBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<AccidentalBatchRowModel, AccidentalBatchUIModel, AccidentalBatchUI> {
    private static final Log log = LogFactory.getLog(AccidentalBatchUIHandler.class);

    public AccidentalBatchUIHandler(TuttiUI<?, ?> parentUi, AccidentalBatchUI ui) {
        super(parentUi, ui, "species", "weight", "comment");
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        AccidentalBatchUIModel model = (AccidentalBatchUIModel)((Object)this.getModel());
        if (empty) {
            rows = null;
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Get accidental batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew((IdAware)bean)) {
                List catches = this.persistenceService.getAllAccidentalBatch(bean.getId());
                for (AccidentalBatch aBatch : catches) {
                    AccidentalBatchRowModel entry = new AccidentalBatchRowModel(aBatch);
                    rows.add(entry);
                }
            }
        }
        model.setRows(rows);
    }

    public AccidentalBatchTableModel getTableModel() {
        return (AccidentalBatchTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((AccidentalBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(AccidentalBatchRowModel row) {
        boolean result = row.getSpecies() != null && row.getWeight() != null;
        return result;
    }

    @Override
    protected void onRowModified(int rowIndex, AccidentalBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<AccidentalBatchRowModel> rowMonitor, AccidentalBatchRowModel row) {
        if (row.isValid()) {
            if (rowMonitor.wasModified()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Row " + (Object)((Object)row) + " was modified, will save it"));
                }
                this.saveRow(row);
                rowMonitor.clearModified();
            }
        } else {
            AccidentalBatch catchBean = (AccidentalBatch)row.toBean();
            if (!TuttiEntities.isNew((IdAware)catchBean)) {
                this.persistenceService.deleteAccidentalBatch(catchBean.getId());
            }
        }
    }

    @Override
    public SwingValidator<AccidentalBatchUIModel> getValidator() {
        return null;
    }

    @Override
    public void beforeInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("beforeInit: " + this.ui));
        }
        EditCatchesUIModel catchesUIModel = ((AccidentalBatchUI)this.ui).getContextValue(EditCatchesUIModel.class);
        AccidentalBatchUIModel model = new AccidentalBatchUIModel(catchesUIModel);
        ((AccidentalBatchUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        List<Species> allSpecies = this.getDataContext().getSpecies();
        Decorator<Species> decorator = this.getDecorator(Species.class, null);
        this.addComboDataColumnToModel((TableColumnModel)columnModel, AccidentalBatchTableModel.SPECIES_BY_CODE, decorator, allSpecies);
        decorator = this.getDecorator(Species.class, null);
        this.addComboDataColumnToModel((TableColumnModel)columnModel, AccidentalBatchTableModel.SPECIES_BY_GENUS_CODE, decorator, allSpecies);
        this.addFloatColumnToModel((TableColumnModel)columnModel, AccidentalBatchTableModel.WEIGHT, "\\d{0,6}|\\d{1,6}\\.\\d{0,3}");
        this.addColumnToModel((TableColumnModel)columnModel, LongTextCellComponent.newEditor(((AccidentalBatchUI)this.ui).getLongTextEditor()), LongTextCellComponent.newRender(I18n.n_((String)"tutti.tooltip.comment.none", (Object[])new Object[0])), AccidentalBatchTableModel.COMMENT);
        decorator = this.getDecorator(Attachment.class, null);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(this.ui), AttachmentCellRenderer.newRender(decorator), AccidentalBatchTableModel.ATTACHMENTS);
        AccidentalBatchTableModel tableModel = new AccidentalBatchTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModel)columnModel, tableModel);
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
    }

    protected void saveRow(AccidentalBatchRowModel row) {
        AccidentalBatch catchBean = (AccidentalBatch)row.toBean();
        FishingOperation fishingOperation = ((AccidentalBatchUIModel)((Object)this.getModel())).getFishingOperation();
        catchBean.setFishingOperation(fishingOperation);
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected fishingOperation: " + fishingOperation.getId()));
        }
        if (TuttiEntities.isNew((IdAware)catchBean)) {
            catchBean = this.persistenceService.createAccidentalBatch(catchBean);
            row.setId(catchBean.getId());
        } else {
            this.persistenceService.saveAccidentalBatch(catchBean);
        }
    }
}

