/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TuttiExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Log log = LogFactory.getLog(TuttiExceptionHandler.class);

    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        this.handleException(t.getName(), ex);
    }

    public void handle(Throwable thrown) {
        this.handleException(Thread.currentThread().getName(), thrown);
    }

    protected void handleException(String tname, Throwable ex) {
        Throwable cause;
        if (log.isErrorEnabled()) {
            log.error((Object)("Global application exception [" + tname + "]"), ex);
        }
        if ((cause = ex) instanceof TuttiTechnicalException) {
            cause = cause.getCause();
        }
        boolean backToScreen = false;
        AbstractTuttiAction action = null;
        if (cause instanceof TuttiActionException) {
            TuttiActionException actionException = (TuttiActionException)cause;
            cause = cause.getCause();
            action = actionException.getAction();
            if (action instanceof AbstractChangeScreenAction) {
                backToScreen = true;
            }
        }
        TuttiUIContext.getErrorHelper().showErrorDialog(cause.getMessage(), ex);
        if (backToScreen) {
            action.getContext().setScreen(TuttiScreen.SELECT_CRUISE);
        }
    }
}

