/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategory;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.i18n.I18n;

public class ComputeWeightsAction
extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    protected String errorMessage;

    public ComputeWeightsAction(EditCatchesUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected void doAction() throws Exception {
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        this.computeSpeciesBatches();
        if (this.errorMessage == null) {
            Float speciesTotalSortedWeight = model.getSpeciesTotalSortedWeight();
            if (speciesTotalSortedWeight == null) {
                speciesTotalSortedWeight = model.getSpeciesTotalSortedComputedWeight();
            }
            Float speciesTotalUnsortedWeight = model.getSpeciesTotalUnsortedComputedWeight();
            model.setCatchTotalSortedComputedWeight(speciesTotalSortedWeight);
            model.setCatchTotalUnsortedComputedWeight(speciesTotalUnsortedWeight);
            Float totalWeight = model.getCatchTotalWeight();
            Float rejectedWeight = model.getCatchTotalRejectedWeight();
            if (rejectedWeight == null && totalWeight != null) {
                if (!totalWeight.equals(Float.valueOf(speciesTotalUnsortedWeight.floatValue() + speciesTotalSortedWeight.floatValue()))) {
                    this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentTotal", (Object[])new Object[0]);
                } else {
                    model.setCatchTotalRejectedComputedWeight(Float.valueOf(totalWeight.floatValue() - speciesTotalUnsortedWeight.floatValue() - speciesTotalSortedWeight.floatValue()));
                }
            } else if (totalWeight == null) {
                if (rejectedWeight == null) {
                    rejectedWeight = Float.valueOf(0.0f);
                    model.setCatchTotalRejectedComputedWeight(Float.valueOf(0.0f));
                }
                model.setCatchTotalComputedWeight(Float.valueOf(speciesTotalUnsortedWeight.floatValue() + speciesTotalSortedWeight.floatValue() + rejectedWeight.floatValue()));
            } else if (rejectedWeight != null && !totalWeight.equals(Float.valueOf(speciesTotalUnsortedWeight.floatValue() + speciesTotalSortedWeight.floatValue() + rejectedWeight.floatValue()))) {
                this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentTotal", (Object[])new Object[0]);
            }
        }
        if (this.errorMessage != null) {
            throw new TuttiBusinessException(this.errorMessage);
        }
    }

    protected void computeSpeciesBatches() {
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        Float totalSortedWeight = Float.valueOf(0.0f);
        Float totalUnsortedWeight = Float.valueOf(0.0f);
        SpeciesBatchUI speciesUI = ((EditCatchesUI)this.getUI()).getSpeciesTabContent();
        EditCatchesUI ui = (EditCatchesUI)this.getUI();
        List roots = ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getModel().getRows();
        for (int i = 0; i < roots.size(); ++i) {
            SpeciesBatchRowModel row = (SpeciesBatchRowModel)roots.get(i);
            if (!row.isBatchRoot()) continue;
            Float weight = this.computeSpeciesBatch(row);
            if (weight == null) {
                this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.noWeight", (Object[])new Object[0]);
                AbstractSelectTableAction.doSelectCell((JTable)speciesUI.getTable(), i, 1);
                break;
            }
            if (persistenceService.isSortedQualitativeValue(row.getSortedUnsortedCategory().getCategoryValue())) {
                totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + weight.floatValue());
                continue;
            }
            totalUnsortedWeight = Float.valueOf(totalUnsortedWeight.floatValue() + weight.floatValue());
        }
        if (this.errorMessage == null) {
            int answer;
            Float inertWeight = model.getSpeciesTotalInertWeight();
            if (inertWeight != null) {
                totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + ((Number)inertWeight).floatValue());
            } else {
                model.setSpeciesTotalInertComputedWeight(Float.valueOf(0.0f));
            }
            Float livingNotItemizedWeight = model.getSpeciesTotalLivingNotItemizedWeight();
            if (livingNotItemizedWeight != null) {
                totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + ((Number)livingNotItemizedWeight).floatValue());
            } else {
                model.setSpeciesTotalLivingNotItemizedComputedWeight(Float.valueOf(0.0f));
            }
            model.setSpeciesTotalSampleSortedComputedWeight(totalSortedWeight);
            Float speciesTotalSortedWeight = model.getSpeciesTotalSortedWeight();
            Float rate = this.getConfig().getDifferenceRateBetweenSortedAndTotalWeights();
            if (speciesTotalSortedWeight == null) {
                speciesTotalSortedWeight = totalSortedWeight;
                model.setSpeciesTotalSortedComputedWeight(totalSortedWeight);
            } else if (speciesTotalSortedWeight.floatValue() < totalSortedWeight.floatValue()) {
                this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentSpeciesTotalSorted", (Object[])new Object[0]);
            } else if (speciesTotalSortedWeight.floatValue() < (1.0f + rate.floatValue() / 100.0f) * totalSortedWeight.floatValue() && (answer = JOptionPane.showConfirmDialog(this.getContext().getActionUI(), I18n._((String)"tutti.action.computeWeights.replaceTotalSortedWeight.message", (Object[])new Object[]{rate}), I18n._((String)"tutti.action.computeWeights.replaceTotalSortedWeight.title", (Object[])new Object[0]), 0, 3)) == 1) {
                model.setSpeciesTotalSortedWeight(null);
                speciesTotalSortedWeight = totalSortedWeight;
                model.setSpeciesTotalSortedComputedWeight(totalSortedWeight);
            }
            model.setSpeciesTotalUnsortedComputedWeight(totalUnsortedWeight);
            Float totalWeight = Float.valueOf(totalUnsortedWeight.floatValue() + speciesTotalSortedWeight.floatValue());
            model.setSpeciesTotalComputedWeight(totalWeight);
        }
        speciesUI.getTable().repaint();
    }

    protected Float computeSpeciesBatch(SpeciesBatchRowModel row) {
        SampleCategory finestCategory = row.getFinestCategory();
        Float result = null;
        Float categoryWeight = finestCategory.getCategoryWeight();
        Float rowWeight = row.getWeight();
        List<SpeciesBatchRowModel> children = row.getChildBatch();
        if (!row.isBatchLeaf()) {
            Float sum = Float.valueOf(0.0f);
            for (SpeciesBatchRowModel child : children) {
                Float weight = this.computeSpeciesBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum = Float.valueOf(sum.floatValue() + weight.floatValue());
            }
            if (sum != null) {
                if (categoryWeight == null) {
                    finestCategory.setComputedWeight(sum);
                    for (SpeciesBatchRowModel child : children) {
                        child.getFinestCategory().setSubSample(false);
                    }
                } else if (categoryWeight.floatValue() < sum.floatValue()) {
                    this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentParentCategoryWeight", (Object[])new Object[0]);
                } else {
                    boolean subSample = categoryWeight.floatValue() > sum.floatValue();
                    for (SpeciesBatchRowModel child : children) {
                        child.getFinestCategory().setSubSample(subSample);
                    }
                }
                result = sum;
            }
        } else {
            row.setComputedWeight(null);
            List<SpeciesFrequencyRowModel> frequency = row.getFrequency();
            if (CollectionUtils.isNotEmpty(frequency)) {
                Float frequencyWeight = Float.valueOf(0.0f);
                for (SpeciesFrequencyRowModel frequencyModel : frequency) {
                    Float w = frequencyModel.getWeight();
                    if (w == null) {
                        frequencyWeight = null;
                        break;
                    }
                    if (frequencyWeight == null) continue;
                    frequencyWeight = Float.valueOf(frequencyWeight.floatValue() + w.floatValue());
                }
                if (categoryWeight == null && rowWeight != null) {
                    this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentRowWeightCategory", (Object[])new Object[0]);
                } else if (categoryWeight == null && frequencyWeight != null) {
                    finestCategory.setComputedWeight(frequencyWeight);
                    result = frequencyWeight;
                } else if (frequencyWeight != null && !frequencyWeight.equals(categoryWeight)) {
                    if (frequencyWeight.floatValue() > categoryWeight.floatValue()) {
                        this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentCategoryWeight", (Object[])new Object[0]);
                    } else if (rowWeight == null) {
                        row.setComputedWeight(frequencyWeight);
                    } else if (!rowWeight.equals(frequencyWeight)) {
                        this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentRowWeightFrequency", (Object[])new Object[0]);
                    }
                    result = categoryWeight;
                } else {
                    result = categoryWeight;
                }
            } else {
                result = categoryWeight;
            }
        }
        return result;
    }
}

