
package fr.ifremer.tutti.ui.swing.util;

/*
 * #%L
 * Tutti :: UI
 * $Id: CustomTab.java 567 2013-03-09 13:59:14Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/CustomTab.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import jaxx.runtime.SwingUtil;

import javax.swing.JLabel;
import javax.swing.JPanel;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import static org.nuiton.i18n.I18n._;

/**
 * Custom tab component which adds a * in the end of the title
 * when the content is modified.
 *
 * @author kmorin <kmorin@codelutin.com>
 * @since 0.3
 */
public class CustomTab extends JPanel {

    private static final long serialVersionUID = 1L;

    protected AbstractTuttiBeanUIModel model;

    protected JLabel title = new JLabel();

    public AbstractTuttiBeanUIModel getModel() {
        return model;
    }

    public CustomTab(AbstractTuttiBeanUIModel model) {
        this.model = model;
        this.model.addPropertyChangeListener(AbstractTuttiBeanUIModel.PROPERTY_MODIFY, new PropertyChangeListener() {

            public void propertyChange(PropertyChangeEvent evt) {
                Boolean modified = (Boolean) evt.getNewValue();
                String title = _(CustomTab.this.model.getTitle());
                if (modified) {
                    title = "<html><strong>" + title + "*</strong></html>";
                }
                CustomTab.this.title.setText(title);
            }
        });

        setBackground(null);

        title.setText(_(model.getTitle()));
        String actionIcon = model.getIcon();
        if (actionIcon != null) {
            title.setIcon(SwingUtil.createActionIcon(actionIcon));
        }
        add(title);
    }

    @Override
    public void setBackground(Color bg) {
        if (bg == null) {
            bg = new Color(0, 0, 0, 0);
        }
        super.setBackground(bg);
        revalidate();
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (title != null) {
            title.setForeground(fg);
        }
    }

}
