package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

/*
 * #%L
 * Tutti :: UI
 * $Id: SplitSpeciesBatchUIModel.java 362 2013-02-07 22:31:52Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/split/SplitSpeciesBatchUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategoryType;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;

import java.util.List;

/**
 * Model of {@link SplitSpeciesBatchUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class SplitSpeciesBatchUIModel
        extends AbstractTuttiTableUIModel<SpeciesBatchRowModel, SplitSpeciesBatchRowModel, SplitSpeciesBatchUIModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_CATEGORY = "category";

    public static final String PROPERTY_SPECIES = "species";

    public static final String PROPERTY_SELECTED_CATEGORY = "selectedCategory";

    public static final String PROPERTY_BATCH_WEIGHT = "batchWeight";

    public static final String PROPERTY_SAMPLE_WEIGHT = "sampleWeight";

    /**
     * Batch which fires the editor.
     *
     * @since 0.3
     */
    protected SpeciesBatchRowModel batch;

    /**
     * Sample categories.
     *
     * @since 0.3
     */
    protected List<SampleCategoryType> category;

    /**
     * Selected Sample category.
     *
     * @since 0.3
     */
    protected SampleCategoryType selectedCategory;

    /**
     * Sample weight of split batches.
     *
     * @since 0.3
     */
    protected Float sampleWeight;

    public SplitSpeciesBatchUIModel() {
        super(SpeciesBatchRowModel.class, null, null);
    }

    public SpeciesBatchRowModel getBatch() {
        return batch;
    }

    public void setBatch(SpeciesBatchRowModel batch) {
        Object oldSpecies = getSpecies();
        Object oldWeight = getBatchWeight();

        this.batch = batch;
        firePropertyChange(PROPERTY_SPECIES, oldSpecies, getSpecies());
        firePropertyChange(PROPERTY_BATCH_WEIGHT, oldWeight, getBatchWeight());
    }

    public Species getSpecies() {
        return batch == null ? null : batch.getSpecies();
    }

    public List<SampleCategoryType> getCategory() {
        return category;
    }

    public void setCategory(List<SampleCategoryType> category) {
        Object oldValue = getCategory();
        this.category = category;
        firePropertyChange(PROPERTY_CATEGORY, oldValue, category);
    }

    public SampleCategoryType getSelectedCategory() {
        return selectedCategory;
    }

    public void setSelectedCategory(SampleCategoryType selectedCategory) {
        Object oldValue = getSelectedCategory();
        this.selectedCategory = selectedCategory;
        firePropertyChange(PROPERTY_SELECTED_CATEGORY, oldValue, selectedCategory);
    }

    public Float getBatchWeight() {
        return batch == null ? null : batch.getSampleCategory().getCategoryWeight();
    }

    public Float getSampleWeight() {
        return sampleWeight;
    }

    public void setSampleWeight(Float sampleWeight) {
        Object oldValue = getSampleWeight();
        this.sampleWeight = sampleWeight;
        firePropertyChange(PROPERTY_SAMPLE_WEIGHT, oldValue, sampleWeight);
    }
}