package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id: UpdateReferentialAction.java 573 2013-03-11 10:34:37Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/UpdateReferentialAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.updater.ApplicationUpdater;

import java.io.File;

/**
 * To update referential using the {@link ApplicationUpdater} mecanism.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class UpdateReferentialAction extends AbstractMainUITuttiAction {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(UpdateReferentialAction.class);

    public UpdateReferentialAction(MainUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected void doAction() {
        TuttiUIContext context = getContext();
        TuttiApplicationConfig config = context.getConfig();

        File current = config.getDataDirectory();
        String url = config.getUpdateUrl();

        if (log.isInfoEnabled()) {
            log.info(String.format("Try to update db (current data location: %s), using update url: %s", current, url));
        }
        ApplicationUpdater up = new ApplicationUpdater();

        File dest = new File(config.getTuttiBasedir(), "NEW");
        ProgressionModel progressionModel = new ProgressionModel();
        context.getActionUI().getModel().setProgressionModel(progressionModel);
        progressionModel.setMessage("Recherche de mises à jour de base");
        TuttiApplicationUpdaterCallBack callback =
                new TuttiApplicationUpdaterCallBack(this, progressionModel);
        callback.setTypes(TuttiApplicationUpdaterCallBack.UpdateType.DB);
        up.update(url,
                  current,
                  dest,
                  false,
                  callback);

        if (callback.isDbUpdated()) {

            progressionModel.setMessage("Rechargement de la base de données");

            context.setDbLoaded(true);
            context.reloadPersistenceService();

            // make sure title is reloaded
            getUI().getHandler().changeTitle();

        } else {
            sendMessage("Aucune mise à jour de base détectée.");
        }
    }
}