/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.ezware.oxbow.swingbits.util.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportProtocolAction
extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {
    private static final Log log = LogFactory.getLog(ExportProtocolAction.class);
    protected File file;

    public ExportProtocolAction(SelectCruiseUIHandler handler) {
        super(handler, "export", I18n._((String)"tutti.action.exportProtocol", (Object[])new Object[0]), I18n._((String)"tutti.action.exportProtocol.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected boolean prepareAction() {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.protocolExportFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseProtocolFile", (Object[])new Object[0]), null, "^.+\\.tuttiProtocol$", I18n._((String)"tutti.file.protocol", (Object[])new Object[0]));
            boolean bl = doAction = this.file != null;
            if (doAction) {
                this.file = TuttiIOUtil.addExtensionIfMissing((File)this.file, (String)".tuttiProtocol$");
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        super.releaseAction();
        this.file = null;
    }

    @Override
    protected void doAction() throws Exception {
        TuttiProtocol protocol = ((SelectCruiseUIModel)((Object)this.getModel())).getProtocol();
        Preconditions.checkNotNull((Object)protocol);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will save protocol " + protocol.getId() + " to file: " + this.file));
        }
        TuttiProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        service.exportProtocol(protocol, this.file);
        this.sendMessage("Protocole [" + protocol.getName() + "] export\u00e9 dans le fichier " + this.file.getName() + ".");
        ((SelectCruiseUIHandler)this.getHandler()).resetEditProtolAction();
    }
}

