/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.ezware.oxbow.swingbits.util.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportAllCaracteristicAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(ExportAllCaracteristicAction.class);
    protected File file;

    public ExportAllCaracteristicAction(EditProtocolUIHandler handler) {
        super(handler, "export", I18n._((String)"tutti.action.exportAllCaracteristic", (Object[])new Object[0]), I18n._((String)"tutti.action.exportAllCaracteristic.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected boolean prepareAction() {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.protocolCaracteristicExportFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseProtocolCaracteristicFile", (Object[])new Object[0]), null, "^.*\\.csv", I18n._((String)"tutti.file.csv", (Object[])new Object[0]));
            if (this.file == null) {
                doAction = false;
            } else {
                this.file = TuttiIOUtil.addExtensionIfMissing(this.file, ".csv");
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export all caracteristic to file: " + this.file));
        }
        TuttiProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        service.exportAllCaracteristic(this.file, ((EditProtocolUIModel)this.getModel()).getAllCaracteristic());
        this.sendMessage(I18n._((String)"tutti.flash.information.all.caractristic.exported", (Object[])new Object[]{this.file}));
    }
}

