/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.data.FishingOperationAware;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TuttiEntities {
    private static final Log log = LogFactory.getLog(TuttiEntities.class);
    public static final Function<Species, String> GET_TAXON_ID = new Function<Species, String>(){

        public String apply(Species input) {
            return String.valueOf(input.getReferenceTaxonId());
        }
    };
    public static final Function<IdAware, String> GET_ID = new Function<IdAware, String>(){

        public String apply(IdAware input) {
            return input.getId();
        }
    };

    protected TuttiEntities() {
    }

    public static <B extends IdAware> List<String> toIds(List<B> list) {
        List result = list == null ? Collections.emptyList() : Lists.transform(list, GET_ID);
        return result;
    }

    public static Set<String> toTaxonIds(List<Species> list) {
        HashSet result = list == null ? Collections.emptySet() : Sets.newHashSet((Iterable)Lists.transform(list, GET_TAXON_ID));
        return result;
    }

    public static <B extends IdAware> Map<String, B> splitById(Iterable<B> list) {
        return Maps.uniqueIndex(list, GET_ID);
    }

    public static Map<String, Species> splitByTaxonId(Iterable<Species> list) {
        return Maps.uniqueIndex(list, GET_TAXON_ID);
    }

    public static Multimap<String, Species> splitByReferenceTaxonId(Iterable<Species> list) {
        return Multimaps.index(list, GET_TAXON_ID);
    }

    public static <B extends IdAware> boolean isNew(B bean) {
        return bean.getId() == null;
    }

    public static <B extends IdAware> Predicate<B> newIdPredicate(String id) {
        return new IdPredicate(id);
    }

    public static <B extends FishingOperationAware> Predicate<B> newTraitIdPredicate(String id) {
        return new TraitIdPredicate(id);
    }

    public static Predicate<Caracteristic> newCaracteristicCategoryPredicate(String cateogryId) {
        return new CaracteristicCategoryPredicate(cateogryId);
    }

    public static <B extends IdAware> B findById(Iterable<B> beans, String id) {
        IdAware result = (IdAware)Iterables.tryFind(beans, TuttiEntities.newIdPredicate(id)).orNull();
        return (B)result;
    }

    public static void closeSilently(Statement statement) {
        block7: {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
            }
            catch (AbstractMethodError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this linkage error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (IllegalAccessError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this IllegalAccessError error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Could not close statement, but do not care", (Throwable)e);
            }
        }
    }

    public static void closeSilently(ResultSet statement) {
        block7: {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
            }
            catch (AbstractMethodError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this linkage error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (IllegalAccessError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this IllegalAccessError error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Could not close statement, but do not care", (Throwable)e);
            }
        }
    }

    public static void closeSilently(Connection connection) {
        block3: {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Could not close connection, but do not care", (Throwable)e);
            }
        }
    }

    public static Connection createConnection(Properties connectionProperties) throws SQLException {
        return TuttiEntities.createConnection(connectionProperties.getProperty("hibernate.connection.url"), connectionProperties.getProperty("hibernate.connection.username"), connectionProperties.getProperty("hibernate.connection.password"));
    }

    public static String getUrl(Properties connectionProperties) {
        return connectionProperties.getProperty("hibernate.connection.url");
    }

    public static Connection createConnection(String jdbcUrl, String user, String password) throws SQLException {
        Connection connection = DriverManager.getConnection(jdbcUrl, user, password);
        connection.setAutoCommit(false);
        return connection;
    }

    public static <B extends IdAware> List<String> collecIds(List<B> list) {
        List result = Lists.transform(list, GET_ID);
        return result;
    }

    public static void fillConnectionProperties(Properties p, String url, String username, String password) {
        p.put("hibernate.connection.url", url);
        p.put("hibernate.connection.username", username);
        p.put("hibernate.connection.password", password);
    }

    public static String getJdbcUrl(File directory, String dbName) {
        return "jdbc:hsqldb:file:" + directory.getAbsolutePath() + "/" + dbName;
    }

    public static <B extends IdAware> B newEntity(B entity) {
        return (B)TuttiEntities.newEntity(entity.getClass());
    }

    public static <B extends IdAware> B newEntity(Class<B> type) {
        try {
            return (B)((IdAware)type.newInstance());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static <K, V> void fillEntries(Map<K, V> map, Collection<K> keys, Function<K, V> function) {
        for (K key : keys) {
            Object value = function.apply(key);
            map.put(key, value);
        }
    }

    public static <K, V> Function<K, V> newConstantFunction(final V value) {
        return new Function<K, V>(){

            public V apply(K input) {
                return value;
            }
        };
    }

    public static CaracteristicType getType(boolean isAlpha, boolean isQualitative) {
        CaracteristicType result = isAlpha ? CaracteristicType.TEXT : (isQualitative ? CaracteristicType.QUALITATIVE : CaracteristicType.NUMBER);
        return result;
    }

    public static boolean isNumberCaracteristic(Caracteristic c) {
        return CaracteristicType.NUMBER == c.getCaracteristicType();
    }

    public static boolean isTextCaracteristic(Caracteristic c) {
        return CaracteristicType.TEXT == c.getCaracteristicType();
    }

    public static boolean isQualitativeCaracteristic(Caracteristic c) {
        return CaracteristicType.QUALITATIVE == c.getCaracteristicType();
    }

    public static <E> List<E> getList(List<E> list) {
        ArrayList result = CollectionUtils.isEmpty(list) ? Lists.newArrayList() : Lists.newArrayList(list);
        return result;
    }

    protected static class TraitIdPredicate<B extends FishingOperationAware>
    implements Predicate<B> {
        private final String id;

        public TraitIdPredicate(String id) {
            this.id = id;
        }

        public boolean apply(B input) {
            return this.id.equals(input.getFishingOperation().getId());
        }
    }

    protected static class CaracteristicCategoryPredicate
    implements Predicate<Caracteristic> {
        private final String id;

        public CaracteristicCategoryPredicate(String id) {
            this.id = id;
        }

        public boolean apply(Caracteristic input) {
            return this.id.equals(input.getCategory());
        }
    }

    protected static class IdPredicate<B extends IdAware>
    implements Predicate<B> {
        private final String id;

        public IdPredicate(String id) {
            this.id = id;
        }

        public boolean apply(B input) {
            return this.id.equals(input.getId());
        }
    }
}

