/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.config;

import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.service.config.TuttiServiceConfigOption;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.nuiton.util.Version;
import org.nuiton.util.config.ApplicationConfig;

public class TuttiServiceConfig {
    protected final ApplicationConfig applicationConfig;
    protected final TuttiPersistenceConfig persistenceConfig;

    public TuttiServiceConfig(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
        this.persistenceConfig = new TuttiPersistenceConfig(applicationConfig);
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public TuttiPersistenceConfig getPersistenceConfig() {
        return this.persistenceConfig;
    }

    public Version getVersion() {
        return this.applicationConfig.getOptionAsVersion(TuttiServiceConfigOption.VERSION.getKey());
    }

    public URL getSiteUrl() {
        return this.applicationConfig.getOptionAsURL(TuttiServiceConfigOption.SITE_URL.getKey());
    }

    public String getOrganizationName() {
        return this.applicationConfig.getOption(TuttiServiceConfigOption.ORGANIZATION_NAME.getKey());
    }

    public int getInceptionYear() {
        return this.applicationConfig.getOptionAsInt(TuttiServiceConfigOption.INCEPTION_YEAR.getKey());
    }

    public File getBasedir() {
        File result = this.applicationConfig.getOptionAsFile(TuttiServiceConfigOption.BASEDIR.getKey());
        return result;
    }

    public File getDataDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiServiceConfigOption.DATA_DIRECTORY.getKey());
        return result;
    }

    public File getTmpDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiServiceConfigOption.TMP_DIRECTORY.getKey());
        return result;
    }

    public File newTempFile(String basename) {
        return new File(this.getTmpDirectory(), basename + "_" + System.nanoTime());
    }

    public char getCsvSeparator() {
        return this.applicationConfig.getOption(TuttiServiceConfigOption.CSV_SEPARATOR.getKey()).charAt(0);
    }

    public void prepareDirectories() throws IOException {
        FileUtils.forceMkdir((File)this.getDataDirectory());
        File tmpDirectory = this.getTmpDirectory();
        if (tmpDirectory.exists()) {
            FileUtils.deleteDirectory((File)tmpDirectory);
        }
        FileUtils.forceMkdir((File)tmpDirectory);
    }
}

