/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Zone;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.TuttiDecorator;
import fr.ifremer.tutti.service.TuttiServiceContext;
import java.io.Serializable;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.util.decorator.DecoratorProvider;

public class DecoratorService
extends AbstractTuttiService {
    public static final String SPECIES_BY_CRUISE_CODE = "byCruiseCode";
    public static final String SPECIES_BY_REF_TAX_CODE = "byRefTaxCode";
    public static final String SPECIES_BY_GENUS = "byGenus";
    public static final String CARACTERISTIC_WITH_UNIT = "withUnit";
    public static final String BY_NAME = "byName";
    public static final String SEPARATOR = "#";
    protected DecoratorProvider decoratorProvider;

    public <O> Decorator<O> getDecorator(O object) {
        return this.decoratorProvider.getDecorator(object);
    }

    public <O> Decorator<O> getDecorator(O object, String name) {
        return this.decoratorProvider.getDecorator(object, name);
    }

    public <O> Decorator<O> getDecoratorByType(Class<O> type) {
        return this.decoratorProvider.getDecoratorByType(type);
    }

    public <O> Decorator<O> getDecoratorByType(Class<O> type, String name) {
        return this.decoratorProvider.getDecoratorByType(type, name);
    }

    public static String getSpeciesContext(boolean protocolFilled) {
        return protocolFilled ? SPECIES_BY_CRUISE_CODE : null;
    }

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.decoratorProvider = new DecoratorProvider(){

            protected void loadDecorators() {
                this.registerTuttiDecorator(Zone.class, "${label}$s#${name}$s", DecoratorService.SEPARATOR, " - ");
                this.registerTuttiDecorator(Cruise.class, "${name}$s", DecoratorService.SEPARATOR, " - ");
                this.registerTuttiDecorator(TuttiProtocol.class, "${name}$s", DecoratorService.SEPARATOR, " - ");
                this.registerTuttiDecorator(FishingOperation.class, "${stationNumber}$s#${fishingOperationNumber}$s#${multirigAggregation}$s#${gearShootingStartDate}$td/%4$tm/%4$tY", DecoratorService.SEPARATOR, " - ");
                this.registerTuttiDecorator(Country.class, "${label}$s#${name}$s", DecoratorService.SEPARATOR, " - ");
                this.registerTuttiDecorator(Gear.class, "${label}$s#${name}$s", DecoratorService.SEPARATOR, " - ");
                this.registerTuttiDecorator(Person.class, "${firstName}$s#${lastName}$s#${department}$s", DecoratorService.SEPARATOR, " ");
                this.registerTuttiDecorator(FishingOperationLocation.class, "${label}$s#${name}$s", DecoratorService.SEPARATOR, " - ");
                this.registerTuttiDecorator(Caracteristic.class, "${parameterName}$s#${matrixName}$s#${fractionName}$s#${methodName}$s", DecoratorService.SEPARATOR, " - ");
                this.registerTuttiDecorator(CaracteristicQualitativeValue.class, "${name}$s", DecoratorService.SEPARATOR, " - ");
                this.registerTuttiDecorator(Species.class, DecoratorService.SPECIES_BY_REF_TAX_CODE, "${refTaxCode}$s", DecoratorService.SEPARATOR, " - ");
                this.registerTuttiDecorator(Species.class, DecoratorService.SPECIES_BY_GENUS, "${name}$s", DecoratorService.SEPARATOR, " - ");
                this.registerTuttiDecorator(SpeciesProtocol.class, "${speciesReferenceTaxonId}", DecoratorService.SEPARATOR, " - ");
                this.registerTuttiDecorator(Attachment.class, "${name}$s", DecoratorService.SEPARATOR, " - ");
                this.registerTuttiDecorator(LabelAware.class, "${label}$s", DecoratorService.SEPARATOR, " - ");
                this.registerDecorator((Decorator)new Decorator<Float>(Float.class){
                    private static final long serialVersionUID = 1L;

                    public String toString(Object bean) {
                        return bean == null ? "" : String.valueOf(bean);
                    }
                });
                this.registerDecorator((Decorator)new VesselDecorator());
                this.registerDecorator((Decorator)new ProgramDecorator());
                this.registerDecorator(DecoratorService.SPECIES_BY_CRUISE_CODE, (Decorator)new SpeciesDecorator());
                this.registerDecorator((Decorator)new SimpleSpeciesDecorator());
                this.registerTuttiDecorator(Caracteristic.class, DecoratorService.CARACTERISTIC_WITH_UNIT, "${parameterName}$s#${matrixName}$s#${fractionName}$s#${methodName}$s (${unit}$s)", DecoratorService.SEPARATOR, " - ");
            }

            public void registerTuttiDecorator(Class<?> klass, String expression, String separator, String separatorReplacement) {
                super.registerDecorator(TuttiDecorator.newDecorator(klass, expression, separator, separatorReplacement));
            }

            public void registerTuttiDecorator(Class<?> klass, String name, String expression, String separator, String separatorReplacement) {
                super.registerDecorator(name, TuttiDecorator.newDecorator(klass, expression, separator, separatorReplacement));
            }
        };
    }

    static {
        I18n.n_((String)"tutti.property.protocol", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.label", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.name", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.firstName", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.lastName", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.department", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.stationNumber", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.internationalRegistrationCode", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.date", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.program", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.parameterName", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.matrixName", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.fractionName", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.methodName", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.cruise", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.fishingOperation", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.fishingOperationLocation", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.zone", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.zoneLabel", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.vessel", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.country", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.gear", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.user", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.strata", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.refTaxCode", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.surveyCode", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.species", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.genusSpecies", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.sortedUnsortedCategory", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.macroWasteCategory", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.attachment", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.multirigAggregation", (Object[])new Object[0]);
        I18n.n_((String)"tutti.property.caracteristic", (Object[])new Object[0]);
    }

    public static class VesselDecorator
    extends TuttiDecorator<Vessel>
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        public VesselDecorator() throws IllegalArgumentException, NullPointerException {
            super(Vessel.class, "${internationalRegistrationCode}$s#${name}$s", DecoratorService.SEPARATOR, " - ");
        }

        @Override
        protected Object onNullValue(Vessel bean, String token) {
            String result = null;
            if ("internationalRegistrationCode".equals(token)) {
                result = I18n._((String)"tutti.propety.no.vessel.internationalRegistrationCode", (Object[])new Object[0]);
            } else if ("name".equals(token)) {
                result = I18n._((String)"tutti.propety.no.vessel.name", (Object[])new Object[0]);
            }
            return result;
        }
    }

    public static class ProgramDecorator
    extends TuttiDecorator<Program>
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        public ProgramDecorator() throws IllegalArgumentException, NullPointerException {
            super(Program.class, "${name}$s#${zoneLabel}$s", DecoratorService.SEPARATOR, " - ");
        }

        @Override
        protected Object onNullValue(Program bean, String token) {
            String result = null;
            if ("zoneLabel".equals(token)) {
                result = I18n._((String)"tutti.propety.no.zone", (Object[])new Object[0]);
            }
            return result;
        }
    }

    public static class SimpleSpeciesDecorator
    extends TuttiDecorator<Species>
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        public SimpleSpeciesDecorator() throws IllegalArgumentException, NullPointerException {
            super(Species.class, "${refTaxCode}$s#${name}$s", DecoratorService.SEPARATOR, " - ");
        }

        @Override
        protected Object onNullValue(Species bean, String token) {
            String result = null;
            if ("refTaxCode".equals(token)) {
                result = I18n._((String)"tutti.propety.no.species.refTaxCode", (Object[])new Object[0]);
            }
            return result;
        }
    }

    public static class SpeciesDecorator
    extends TuttiDecorator<Species>
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        public SpeciesDecorator() throws IllegalArgumentException, NullPointerException {
            super(Species.class, "${surveyCode}$s#${refTaxCode}$s#${name}$s", DecoratorService.SEPARATOR, " - ");
        }

        @Override
        protected Object onNullValue(Species bean, String token) {
            String result = null;
            if ("surveyCode".equals(token)) {
                result = I18n._((String)"tutti.propety.no.species.surveyCode", (Object[])new Object[0]);
            } else if ("refTaxCode".equals(token)) {
                result = I18n._((String)"tutti.propety.no.species.refTaxCode", (Object[])new Object[0]);
            }
            return result;
        }
    }

    public static interface LabelAware
    extends Serializable {
        public String getLabel();
    }
}

