package fr.ifremer.tutti.ui.swing.content.referential;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ManageTemporaryReferentialUI extends JPanel implements TuttiUI<TuttiUIContext, ManageTemporaryReferentialUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRQem9ip4wCtI/KjpNCmKUpBrNNygiBoSRtiyy2hTqoKH+jYO3am2l/MjtuNoiL+BP4EuHMp4sYJceDMgQviX0CoB66INzOb9e5mtmsriZSVPfO9733vzez7/MPfqOQzdOkRDgKDDR1ObWI0bz548Fn3EenxW8TvMepxlyH1VyiiYgdVzWjd5+hypyXC62F4fdO1PdchTix6o4VmfH5gEX+fEM7RhWREz/fr7Wh7I/CG7Ig1EqVj/e75P8VvzW++LyIUeKBuAUq5mBc1qmSqhYrU5KgGmR7juoWdAchg1BmA3pfF2qaFff8utslX6Gs03UJlDzMg42hl/JIlh4wPPAi0sYMHZJdAAMPs4B7pE0FJsbXrejvYIRZHzT4zaJ8RmzCDDzmnxpAa/hMQZvRchwPcYKM4404m5V7D82TuMkfT+9gxLcI4+vz06LcV5yhLyXZNUcJado5d8XWvsSlSBTwmcHUXdy2yztFi4gzDKLEnkJUoYNb3SI8Sv4W7ImVNnFgQwptyUQBrEf7MalM2eD2NlatJ7HkSQLm8rTLcDrDtWeQTUA6q0VwiWq2KuMUofI7asfAR4kISNrvabBO4UxguDKiaT/BGO0ll1cfE94kV1begL/Ka+H4+ubekirovCRI1RdquROCaKkGBM1HxCmTKlWTKyoBglqf1ukbrgtL6KYTrldYj6FmlVEAzMXGd1zU6qx5hvuvkKX0vu6s7kkCv9f10VxX4OIqh1xN3HyajMZqMo9FV6KASG8IyvCyd48P0HmypMbqYGqOCUO7+Nz/3x89//bR1NDtrkPs1LTQ2+mGmecyFVnEqUr+qBueQU6t+B3sbHVSBuwK+IX1hWSOsHW6DOMh3ToQbItzYxv4+UJSm//zl1/mHv7+EiltoxnKxuYUFvoEqfJ9BF1zLDLyPb0hFs0/OwPMs/Bc5mhLDhKNw2FCn7zIbc+o6huq4wY8GWHy4cTQD/IBqiMmHqrG4ALq3rOleVEK38tu/c+1nN446WICKljLhoy6WvkBl6ljUIdJ/QmvR+k3V88nQdEcWojMVlNTthRP1lnxua3tFZbXXDtti0uyJ/vcYwZw0bJj0ohVrK6ot74Yj1hjQ/srVp1Gb31RttsTrkjCLEB8MRfK7sivi0w5Kjes8lQXAfymT3JRCOHrn8LZ8zyIjSs5mBTN6ojFPdelfMNEnF7N62LB1YnJV6IxhnBNTbX8jq+3KE1K3uaxWdTLiJjJ59W+njyLhKLk9yLahyaVcTh+EYs3VoHG38Y9hOesYhNmlDmFKrOkUjJxx8qrX0gcQs8nc0rOcdXIZl9LNF5y5+Y/Z9Sncf+Xe6fuvVrX3P2b3p3D/E94/7v3X/GA4hfuvWMe9//HfIWMkL1v4wAUweuVDE3N8sUsdExzko2MZCuI5k8solp+Jx496hqUTM7x1Yob1EzN8AAz/A8F48pppDwAA";
    private static final Log log = LogFactory.getLog(ManageTemporaryReferentialUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton exportGearExampleButton;
    protected JButton exportPersonExampleButton;
    protected JButton exportSpeciesExampleButton;
    protected JButton exportVesselExampleButton;
    protected JLabel gearLabel;
    protected ManageTemporaryReferentialUIHandler handler;
    protected JButton importGearButton;
    protected JButton importPersonButton;
    protected JButton importSpeciesButton;
    protected JButton importVesselButton;
    protected ManageTemporaryReferentialUI manageTemporaryReferentialTopPanel = this;
    protected TuttiUIContext model;
    protected JLabel personLabel;
    protected JLabel speciesLabel;
    protected JLabel vesselLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JSeparator $JSeparator2;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ManageTemporaryReferentialUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                ManageTemporaryReferentialUIHandler handler =
                               new ManageTemporaryReferentialUIHandler(parentUI.getHandler().getContext(), this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public ManageTemporaryReferentialUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ManageTemporaryReferentialUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ManageTemporaryReferentialUI() {
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ManageTemporaryReferentialUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getExportGearExampleButton() {
        return exportGearExampleButton;
    }

    public JButton getExportPersonExampleButton() {
        return exportPersonExampleButton;
    }

    public JButton getExportSpeciesExampleButton() {
        return exportSpeciesExampleButton;
    }

    public JButton getExportVesselExampleButton() {
        return exportVesselExampleButton;
    }

    public JLabel getGearLabel() {
        return gearLabel;
    }

    public ManageTemporaryReferentialUIHandler getHandler() {
        return handler;
    }

    public JButton getImportGearButton() {
        return importGearButton;
    }

    public JButton getImportPersonButton() {
        return importPersonButton;
    }

    public JButton getImportSpeciesButton() {
        return importSpeciesButton;
    }

    public JButton getImportVesselButton() {
        return importVesselButton;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JLabel getPersonLabel() {
        return personLabel;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public JLabel getVesselLabel() {
        return vesselLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JSeparator get$JSeparator2() {
        return $JSeparator2;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToManageTemporaryReferentialTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createExportGearExampleButton() {
        $objectMap.put("exportGearExampleButton", exportGearExampleButton = new JButton());
        
        exportGearExampleButton.setName("exportGearExampleButton");
        exportGearExampleButton.putClientProperty("tuttiAction", ExportTemporaryGearExampleAction.class);
    }

    protected void createExportPersonExampleButton() {
        $objectMap.put("exportPersonExampleButton", exportPersonExampleButton = new JButton());
        
        exportPersonExampleButton.setName("exportPersonExampleButton");
        exportPersonExampleButton.putClientProperty("tuttiAction", ExportTemporaryPersonExampleAction.class);
    }

    protected void createExportSpeciesExampleButton() {
        $objectMap.put("exportSpeciesExampleButton", exportSpeciesExampleButton = new JButton());
        
        exportSpeciesExampleButton.setName("exportSpeciesExampleButton");
        exportSpeciesExampleButton.putClientProperty("tuttiAction", ExportTemporarySpeciesExampleAction.class);
    }

    protected void createExportVesselExampleButton() {
        $objectMap.put("exportVesselExampleButton", exportVesselExampleButton = new JButton());
        
        exportVesselExampleButton.setName("exportVesselExampleButton");
        exportVesselExampleButton.putClientProperty("tuttiAction", ExportTemporaryVesselExampleAction.class);
    }

    protected void createGearLabel() {
        $objectMap.put("gearLabel", gearLabel = new JLabel());
        
        gearLabel.setName("gearLabel");
        gearLabel.setText(_("tutti.label.referential.gear"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(ManageTemporaryReferentialUIHandler.class));
    }

    protected void createImportGearButton() {
        $objectMap.put("importGearButton", importGearButton = new JButton());
        
        importGearButton.setName("importGearButton");
        importGearButton.putClientProperty("tuttiAction", ImportTemporaryGearAction.class);
    }

    protected void createImportPersonButton() {
        $objectMap.put("importPersonButton", importPersonButton = new JButton());
        
        importPersonButton.setName("importPersonButton");
        importPersonButton.putClientProperty("tuttiAction", ImportTemporaryPersonAction.class);
    }

    protected void createImportSpeciesButton() {
        $objectMap.put("importSpeciesButton", importSpeciesButton = new JButton());
        
        importSpeciesButton.setName("importSpeciesButton");
        importSpeciesButton.putClientProperty("tuttiAction", ImportTemporarySpeciesAction.class);
    }

    protected void createImportVesselButton() {
        $objectMap.put("importVesselButton", importVesselButton = new JButton());
        
        importVesselButton.setName("importVesselButton");
        importVesselButton.putClientProperty("tuttiAction", ImportTemporaryVesselAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createPersonLabel() {
        $objectMap.put("personLabel", personLabel = new JLabel());
        
        personLabel.setName("personLabel");
        personLabel.setText(_("tutti.label.referential.person"));
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
        speciesLabel.setText(_("tutti.label.referential.species"));
    }

    protected void createVesselLabel() {
        $objectMap.put("vesselLabel", vesselLabel = new JLabel());
        
        vesselLabel.setName("vesselLabel");
        vesselLabel.setText(_("tutti.label.referential.vessel"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToManageTemporaryReferentialTopPanel();
        // inline complete setup of $Table0
        $Table0.add(speciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator0, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vesselLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator1, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(gearLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator2, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(personLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(exportSpeciesExampleButton);
        $JPanel0.add(importSpeciesButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(exportVesselExampleButton);
        $JPanel1.add(importVesselButton);
        // inline complete setup of $JPanel2
        $JPanel2.add(exportGearExampleButton);
        $JPanel2.add(importGearButton);
        // inline complete setup of $JPanel3
        $JPanel3.add(exportPersonExampleButton);
        $JPanel3.add(importPersonButton);
        
        // apply 9 property setters
        speciesLabel.setIcon(SwingUtil.createImageIcon("action-species.gif"));
        vesselLabel.setIcon(SwingUtil.createActionIcon("vessel"));
        gearLabel.setIcon(SwingUtil.createActionIcon("gear"));
        personLabel.setIcon(SwingUtil.createActionIcon("person"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("manageTemporaryReferentialTopPanel", manageTemporaryReferentialTopPanel);
        createHandler();
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createSpeciesLabel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createExportSpeciesExampleButton();
        createImportSpeciesButton();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createVesselLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createExportVesselExampleButton();
        createImportVesselButton();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createGearLabel();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createExportGearExampleButton();
        createImportGearButton();
        // inline creation of $JSeparator2
        $objectMap.put("$JSeparator2", $JSeparator2 = new JSeparator());
        
        $JSeparator2.setName("$JSeparator2");
        createPersonLabel();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createExportPersonExampleButton();
        createImportPersonButton();
        // inline creation of manageTemporaryReferentialTopPanel
        setName("manageTemporaryReferentialTopPanel");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}