package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategoryType;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class SplitSpeciesBatchUI extends JPanel implements TuttiUI<SplitSpeciesBatchUIModel, SplitSpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BATCH_WEIGHT_FIELD_TEXT = "batchWeightField.text";
    public static final String BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM = "categoryComboBox.selectedItem";
    public static final String BINDING_SAMPLE_WEIGHT_FIELD_TEXT = "sampleWeightField.text";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SPECIES_FIELD_TEXT = "speciesField.text";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SplitSpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actionPanel;
    protected JTextField batchWeightField;
    protected JLabel batchWeightLabel;
    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedCategory",  editorName = "categoryComboBox")
    protected JComboBox categoryComboBox;
    protected JLabel categoryLabel;
    protected Table configurationPanel;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected SplitSpeciesBatchUIHandler handler;
    protected SplitSpeciesBatchUI homePanel = this;
    protected SplitSpeciesBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleWeight",  editorName = "sampleWeightField")
    protected JTextField sampleWeightField;
    protected JLabel sampleWeightLabel;
    protected JButton saveButton;
    protected JTextField speciesField;
    protected JLabel speciesLabel;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<SplitSpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SplitSpeciesBatchUI(EditCatchesUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            SplitSpeciesBatchUIHandler handler = new SplitSpeciesBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public SplitSpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitSpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitSpeciesBatchUI() {
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitSpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActionPanel() {
        return actionPanel;
    }

    public JTextField getBatchWeightField() {
        return batchWeightField;
    }

    public JLabel getBatchWeightLabel() {
        return batchWeightLabel;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JComboBox getCategoryComboBox() {
        return categoryComboBox;
    }

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public SplitSpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public SplitSpeciesBatchUIModel getModel() {
        return model;
    }

    public JTextField getSampleWeightField() {
        return sampleWeightField;
    }

    public JLabel getSampleWeightLabel() {
        return sampleWeightLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JTextField getSpeciesField() {
        return speciesField;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<SplitSpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(cancelButton);
        actionPanel.add(saveButton);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(categoryLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(categoryComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add($JSeparator0, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(speciesLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(speciesField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(sampleWeightLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleWeightField), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new JPanel());
        
        actionPanel.setName("actionPanel");
        actionPanel.setLayout(new GridLayout(1, 0));
    }

    protected void createBatchWeightField() {
        $objectMap.put("batchWeightField", batchWeightField = new JTextField());
        
        batchWeightField.setName("batchWeightField");
        batchWeightField.setColumns(15);
        batchWeightField.setEnabled(false);
        batchWeightField.setEditable(false);
    }

    protected void createBatchWeightLabel() {
        $objectMap.put("batchWeightLabel", batchWeightLabel = new JLabel());
        
        batchWeightLabel.setName("batchWeightLabel");
        batchWeightLabel.setText(_("tutti.label.sampleCategoryConfiguration.batchWeight"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.action.cancel"));
        cancelButton.setMnemonic(65);
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCategoryComboBox() {
        $objectMap.put("categoryComboBox", categoryComboBox = new JComboBox());
        
        categoryComboBox.setName("categoryComboBox");
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
        categoryLabel.setText(_("tutti.label.sampleCategoryConfiguration.category"));
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SplitSpeciesBatchUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SplitSpeciesBatchUIModel.class));
    }

    protected void createSampleWeightField() {
        $objectMap.put("sampleWeightField", sampleWeightField = new JTextField());
        
        sampleWeightField.setName("sampleWeightField");
        sampleWeightField.setColumns(15);
        sampleWeightField.setEnabled(false);
        sampleWeightField.setEditable(false);
    }

    protected void createSampleWeightLabel() {
        $objectMap.put("sampleWeightLabel", sampleWeightLabel = new JLabel());
        
        sampleWeightLabel.setName("sampleWeightLabel");
        sampleWeightLabel.setText(_("tutti.label.sampleCategoryConfiguration.sampleWeight"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.action.save"));
        saveButton.setMnemonic(69);
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createSpeciesField() {
        $objectMap.put("speciesField", speciesField = new JTextField());
        
        speciesField.setName("speciesField");
        speciesField.setColumns(15);
        speciesField.setEnabled(false);
        speciesField.setEditable(false);
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
        speciesLabel.setText(_("tutti.label.sampleCategoryConfiguration.species"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SplitSpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        addChildrenToTableScrollPane();
        addChildrenToActionPanel();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        configurationPanel.setBorder(new TitledBorder(null, _("tutti.legend.splitSpeciesBatchConfiguration")));
        categoryLabel.setLabelFor(categoryComboBox);
        speciesLabel.setLabelFor(speciesField);
        batchWeightLabel.setLabelFor(batchWeightField);
        sampleWeightLabel.setLabelFor(sampleWeightField);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createConfigurationPanel();
        createCategoryLabel();
        createCategoryComboBox();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createSpeciesLabel();
        createSpeciesField();
        createBatchWeightLabel();
        createBatchWeightField();
        createSampleWeightLabel();
        createSampleWeightField();
        createTableScrollPane();
        createTable();
        createActionPanel();
        createCancelButton();
        createSaveButton();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setSelectedItem(model.getSelectedCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesField, handler.decorateSpecies(model.getSpecies()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(batchWeightField, getStringValue(model.getBatchWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(sampleWeightField, getStringValue(model.getSampleWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getSelectedCategory() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}