package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditCruiseAction.java 512 2013-03-01 20:37:07Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/home/EditCruiseAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;

import static org.nuiton.i18n.I18n._;

/**
 * Opens the cruise edition screen.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class EditCruiseAction extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {

    public EditCruiseAction(SelectCruiseUIHandler handler) {
        super(handler,
              "edit",
              _("tutti.action.editCruise"),
              _("tutti.action.editCruise.tip"),
              true
        );
    }

    @Override
    protected void doAction() {
        Cruise cruise = getModel().getCruise();
        Preconditions.checkNotNull(cruise);
        getContext().setCruiseId(cruise.getId());
        getContext().setScreen(TuttiScreen.EDIT_CRUISE);
    }
}
