/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.ezware.oxbow.swingbits.util.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.home.ImportProtocolAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SelectSpeciesUIModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanDoubleListModel;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditProtocolUIHandler
extends AbstractTuttiTableUIHandler<EditProtocolSpeciesRowModel, EditProtocolUIModel, EditProtocolUI> {
    private static final Log log = LogFactory.getLog(EditProtocolUIHandler.class);
    protected SelectSpeciesUI dialog;

    public EditProtocolUIHandler(TuttiUI parentUi, EditProtocolUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui, new String[0]);
    }

    public EditProtocolSpeciesTableModel getTableModel() {
        return (EditProtocolSpeciesTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((EditProtocolUI)this.ui).getSpeciesTable();
    }

    @Override
    protected boolean isRowValid(EditProtocolSpeciesRowModel row) {
        return true;
    }

    @Override
    protected void onRowModified(int rowIndex, EditProtocolSpeciesRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, EditProtocolSpeciesRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        if (row != null && row.isModify() && newValue != null && newValue.booleanValue()) {
            ((EditProtocolUIModel)this.getModel()).setModify(true);
        }
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<EditProtocolSpeciesRowModel> rowMonitor, EditProtocolSpeciesRowModel row) {
    }

    @Override
    public SwingValidator<EditProtocolUIModel> getValidator() {
        return ((EditProtocolUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        EditProtocolUIModel model = new EditProtocolUIModel();
        ArrayList allSpecies = Lists.newArrayList((Iterable)this.persistenceService.getAllSpecies());
        model.setAllSpecies(allSpecies);
        Multimap<String, Species> allSpeciesByTaxonId = TuttiEntities.splitByReferenceTaxonId(allSpecies);
        model.setAllSpeciesByTaxonId(allSpeciesByTaxonId);
        Map<String, Species> allReferentSpeciesByTaxonId = TuttiEntities.splitByTaxonId(this.persistenceService.getAllReferentSpecies());
        model.setAllReferentSpeciesByTaxonId(allReferentSpeciesByTaxonId);
        List protocols = this.persistenceService.getAllProtocol();
        model.setExistingProtocols(protocols);
        List caracteristics = this.persistenceService.getAllCaracteristic();
        model.setCaracteristics(caracteristics);
        Map<String, Caracteristic> allCaracteristic = TuttiEntities.splitById(caracteristics);
        model.setAllCaracteristic(allCaracteristic);
        this.listModelIsModify(model);
        ((EditProtocolUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        List<Object> rows;
        this.initUI(this.ui);
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        TuttiProtocol protocol = (TuttiProtocol)ImportProtocolAction.IMPORT_PROTOCOL_ENTRY.getContextValue((JAXXContext)this.ui);
        if (protocol != null) {
            ImportProtocolAction.IMPORT_PROTOCOL_ENTRY.removeContextValue((JAXXContext)this.ui);
            model.fromBean(protocol);
            model.setImported(true);
            ((EditProtocolUI)this.ui).getSaveWarning().setText(I18n._((String)"tutti.label.protocol.import.warning", (Object[])new Object[0]));
        } else if (this.context.isProtocolFilled()) {
            protocol = this.persistenceService.getProtocol(this.context.getProtocolId());
            Boolean mustClone = ((EditProtocolUI)this.ui).getContextValue(Boolean.class, "cloneProtocol");
            model.fromBean(protocol);
            if (mustClone != null && mustClone.booleanValue()) {
                ((EditProtocolUI)this.ui).setContextValue(false, "cloneProtocol");
                model.setId(null);
                model.setCloned(true);
                ((EditProtocolUI)this.ui).getSaveWarning().setText(I18n._((String)"tutti.label.protocol.clone.warning", (Object[])new Object[0]));
            } else {
                log.debug(model.getExistingProtocols());
                model.getExistingProtocols().remove(protocol);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Will create a new protocol");
        }
        SwingValidator<EditProtocolUIModel> validator = ((EditProtocolUI)this.ui).getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        this.registerValidators(validator);
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Species.class), EditProtocolSpeciesTableModel.SPECIES_ID);
        this.addColumnToModel((TableColumnModel)columnModel, null, null, EditProtocolSpeciesTableModel.SURVEY_CODE_ID);
        this.addLengthClassesColumnToModel((TableColumnModel)columnModel, model.getLengthClassesPmfmId());
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.WEIGHT_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.COUNT_IF_NO_FREQUENCY_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.SIZE_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.SEX_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.MATURITY_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.AGE_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.CALCIFY_SAMPLE_ENABLED, (JTable)table);
        EditProtocolSpeciesTableModel tableModel = new EditProtocolSpeciesTableModel((TableColumnModel)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
        Collection<Species> referents = model.getAllReferentSpeciesByTaxonId().values();
        ArrayList speciesList = Lists.newArrayList(referents);
        this.initBeanComboBox(((EditProtocolUI)this.ui).getSpeciesComboBox(), speciesList, null);
        if (protocol == null) {
            rows = Lists.newArrayList();
        } else {
            rows = this.toRows(protocol.getSpecies());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit protocol with " + rows.size() + " species declared."));
            }
        }
        model.setRows(rows);
        this.selectFirstInCombo(((EditProtocolUI)this.ui).getSpeciesComboBox());
        this.initDoubleList("lengthClassesPmfmId", ((EditProtocolUI)this.ui).getLengthClassesList(), Lists.newArrayList(model.getCaracteristics()), model.getLengthClassesPmfmId());
        this.initDoubleList("gearPmfmId", ((EditProtocolUI)this.ui).getGearList(), Lists.newArrayList(model.getCaracteristics()), model.getGearPmfmId());
        this.initDoubleList("environmentPmfmId", ((EditProtocolUI)this.ui).getEnvironmentList(), Lists.newArrayList(model.getCaracteristics()), model.getEnvironmentPmfmId());
        this.initDoubleList("hydrologyPmfmId", ((EditProtocolUI)this.ui).getHydrologyList(), Lists.newArrayList(model.getCaracteristics()), model.getHydrologyPmfmId());
        model.setModify(model.isCreate());
        this.dialog = new SelectSpeciesUI(this.ui);
    }

    public List<EditProtocolSpeciesRowModel> toRows(List<SpeciesProtocol> speciesProtocols) {
        List speciesList = ((EditProtocolUI)this.ui).getSpeciesComboBox().getData();
        Preconditions.checkNotNull((Object)speciesList);
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        Map<String, Species> allReferentSpeciesByTaxonId = model.getAllReferentSpeciesByTaxonId();
        Map<String, Caracteristic> allCaracteristic = model.getAllCaracteristic();
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(speciesProtocols)) {
            for (SpeciesProtocol speciesProtocol : speciesProtocols) {
                Integer taxonId = speciesProtocol.getSpeciesReferenceTaxonId();
                String taxonIdStr = String.valueOf(taxonId);
                Collection<Species> allSynonyms = model.getAllSynonyms(taxonIdStr);
                model.getAllSynonyms().removeAll(allSynonyms);
                Species species = allReferentSpeciesByTaxonId.get(taxonIdStr);
                speciesList.remove(species);
                EditProtocolSpeciesRowModel row = this.getTableModel().createNewRow();
                row.setSpecies(species);
                row.setLengthStepPmfm(allCaracteristic.get(speciesProtocol.getLengthStepPmfmId()));
                row.fromBean(speciesProtocol);
                result.add(row);
            }
        }
        return result;
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    @Override
    public boolean canCloseUI(TuttiScreen nextScreen) {
        boolean result = true;
        if (((EditProtocolUIModel)this.getModel()).isModify()) {
            int answer = this.askSaveBeforeLeaving(I18n._((String)"tutti.dialog.askSaveBeforeLeaving.saveProtocol", (Object[])new Object[0]));
            boolean bl = result = answer == 1;
            if (answer == 0) {
                ActionEvent event = new ActionEvent((Object)nextScreen, nextScreen.ordinal(), null);
                this.doAction(((EditProtocolUI)this.ui).getSaveButton(), event);
            }
        }
        return result;
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, EditProtocolSpeciesRowModel oldRow, int newRowIndex, EditProtocolSpeciesRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        ((EditProtocolUIModel)this.getModel()).setRemoveSpeciesEnabled(newRow != null);
    }

    public void addDoubleListListeners() {
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        String id = (String)((EditProtocolUI)this.ui).getLengthClassesList().getClientProperty((Object)"_updateListenerId");
        UpdateSelectedList updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getLengthClassesList().getClientProperty((Object)"_updateListener");
        model.addPropertyChangeListener(id, updateListener);
        id = (String)((EditProtocolUI)this.ui).getEnvironmentList().getClientProperty((Object)"_updateListenerId");
        updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getEnvironmentList().getClientProperty((Object)"_updateListener");
        model.addPropertyChangeListener(id, updateListener);
        id = (String)((EditProtocolUI)this.ui).getGearList().getClientProperty((Object)"_updateListenerId");
        updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getGearList().getClientProperty((Object)"_updateListener");
        model.addPropertyChangeListener(id, updateListener);
        id = (String)((EditProtocolUI)this.ui).getHydrologyList().getClientProperty((Object)"_updateListenerId");
        updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getHydrologyList().getClientProperty((Object)"_updateListener");
        model.addPropertyChangeListener(id, updateListener);
    }

    public void removeDoubleListListeners() {
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        String id = (String)((EditProtocolUI)this.ui).getLengthClassesList().getClientProperty((Object)"_updateListenerId");
        UpdateSelectedList updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getLengthClassesList().getClientProperty((Object)"_updateListener");
        model.removePropertyChangeListener(id, updateListener);
        id = (String)((EditProtocolUI)this.ui).getEnvironmentList().getClientProperty((Object)"_updateListenerId");
        updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getEnvironmentList().getClientProperty((Object)"_updateListener");
        model.removePropertyChangeListener(id, updateListener);
        id = (String)((EditProtocolUI)this.ui).getGearList().getClientProperty((Object)"_updateListenerId");
        updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getGearList().getClientProperty((Object)"_updateListener");
        model.removePropertyChangeListener(id, updateListener);
        id = (String)((EditProtocolUI)this.ui).getHydrologyList().getClientProperty((Object)"_updateListenerId");
        updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getHydrologyList().getClientProperty((Object)"_updateListener");
        model.removePropertyChangeListener(id, updateListener);
    }

    public Species openSelectOtherSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUIModel model = this.dialog.getModel();
        model.setSpecies(species);
        model.setSelectedSpecies(null);
        this.openDialog(this.ui, this.dialog, title, new Dimension(400, 130));
        return model.getSelectedSpecies();
    }

    protected void initDoubleList(String propertyId, BeanDoubleList<Caracteristic> widget, List<Caracteristic> availableCaracteristics, List<String> selectedCaracteristics) {
        this.initBeanList(widget, availableCaracteristics, Lists.newArrayList());
        UpdateSelectedList listener = new UpdateSelectedList(widget, ((EditProtocolUIModel)this.getModel()).getAllCaracteristic());
        widget.putClientProperty((Object)"_updateListener", (Object)listener);
        widget.putClientProperty((Object)"_updateListenerId", (Object)propertyId);
        listener.select(selectedCaracteristics);
    }

    protected void selectLengthClasses(List<String> ids, JComboBox comboBox) {
        ArrayList dataToList;
        Map<String, Caracteristic> allCaracteristic = ((EditProtocolUIModel)this.getModel()).getAllCaracteristic();
        ArrayList selection = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(ids)) {
            for (String id : ids) {
                selection.add(allCaracteristic.get(id));
            }
        }
        if (!(dataToList = Lists.newArrayList((Iterable)selection)).isEmpty() && dataToList.get(0) != null) {
            dataToList.add(0, null);
        }
        SwingUtil.fillComboBox((JComboBox)comboBox, (Collection)dataToList, null);
    }

    protected void addLengthClassesColumnToModel(TableColumnModel model, List<String> selectedIds) {
        Decorator<Caracteristic> decorator = this.getDecorator(Caracteristic.class, null);
        final JComboBox comboBox = new JComboBox();
        ((EditProtocolUIModel)this.getModel()).addPropertyChangeListener("lengthClassesPmfmId", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List ids = (List)evt.getNewValue();
                EditProtocolUIHandler.this.selectLengthClasses(ids, comboBox);
            }
        });
        comboBox.setRenderer(this.newListCellRender(decorator));
        this.selectLengthClasses(selectedIds, comboBox);
        ObjectToStringConverter converter = BeanUIUtil.newDecoratedObjectToStringConverter(decorator);
        BeanUIUtil.decorate(comboBox, (ObjectToStringConverter)converter);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(comboBox);
        this.addColumnToModel(model, (TableCellEditor)editor, this.newTableCellRender(decorator), EditProtocolSpeciesTableModel.LENGTH_STEP_PMFM_ID);
    }

    protected static class UpdateSelectedList
    implements PropertyChangeListener {
        private final BeanDoubleListModel<Caracteristic> model;
        private final Map<String, Caracteristic> caracteristicMap;
        private boolean valueIsAdjusting;

        public UpdateSelectedList(BeanDoubleList<Caracteristic> doubleList, Map<String, Caracteristic> caracteristicMap) {
            this.model = doubleList.getModel();
            this.caracteristicMap = caracteristicMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!this.valueIsAdjusting) {
                this.valueIsAdjusting = true;
                try {
                    List selectedIds = (List)evt.getNewValue();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("[" + evt.getPropertyName() + "] selected ids: " + selectedIds));
                    }
                    this.select(selectedIds);
                }
                finally {
                    this.valueIsAdjusting = false;
                }
            }
        }

        public void select(List<String> selectedIds) {
            ArrayList selection = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(selectedIds)) {
                for (String selectedId : selectedIds) {
                    selection.add(this.caracteristicMap.get(selectedId));
                }
            }
            this.model.setSelected((List)selection);
        }
    }
}

