package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportProtocolSpeciesAction.java 455 2013-02-22 17:47:32Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/ImportProtocolSpeciesAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * To import protocol species.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ImportProtocolSpeciesAction extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ImportProtocolSpeciesAction.class);

    private File file;

    public ImportProtocolSpeciesAction(EditProtocolUIHandler handler) {
        super(handler,
              "importProtocolSpecies",
              "import",
              _("tutti.action.importProtocolSpecies"),
              _("tutti.action.importProtocolSpecies.tip"),
              false
        );
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {

        // choose file to import
        file = TuttiUIUtil.chooseFile(
                getContext().getMainUI(),
                _("tutti.title.choose.protocolSpeciesImportFile"),
                _("tutti.action.chooseProtocolSpeciesFile"),
                null,
                "^.*\\.csv", _("tutti.file.csv")
        );
        boolean doAction = file != null;
        if (doAction) {
            super.prepareAction(event);
        }
        return doAction;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        super.releaseAction(event);
        file = null;
    }

    @Override
    protected void doAction(ActionEvent e) throws Exception {

        if (log.isInfoEnabled()) {
            log.info("Will import protocol species file: " + file);
        }

        EditProtocolUIHandler handler = getHandler();
        EditProtocolUIModel model = getModel();

        // bind to a protocol
        TuttiProtocol protocol = model.toBean();

        // import
        TuttiProtocolImportExportService service =
                getService(TuttiProtocolImportExportService.class);

        service.importProtocolSpecies(file,
                                      protocol,
                                      model.getAllCaracteristic(),
                                      model.getAllReferentSpeciesByTaxonId());

        BeanComboBox<Species> speciesComboBox = getUI().getSpeciesComboBox();

        // build rows from imported+merged protocol
        // (will also remove all synonyms of species referent used)
        List<EditProtocolSpeciesRowModel> rows =
                handler.toRows(protocol.getSpecies());

        // update species comboBox
        speciesComboBox.getHandler().sortData();
        handler.selectFirstInCombo(speciesComboBox);

        // update rows in model
        model.setRows(rows);

        sendMessage(_("tutti.flash.information.species.imported.in.protocol",
                      file));
    }
}