package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportProtocolSpeciesAction.java 383 2013-02-10 15:00:32Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/ExportProtocolSpeciesAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * To export protocol species.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ExportProtocolSpeciesAction extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ExportProtocolSpeciesAction.class);

    private File file;

    public ExportProtocolSpeciesAction(EditProtocolUIHandler handler) {
        super(handler,
              "exportProtocolSpecies",
              "export",
              _("tutti.action.exportProtocolSpecies"),
              _("tutti.action.exportProtocolSpecies.tip"),
              true
        );
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {

        // choose file to export
        file = TuttiUIUtil.chooseFile(
                getContext().getMainUI(),
                _("tutti.title.choose.protocolSpeciesExportFile"),
                _("tutti.action.chooseProtocolSpeciesFile"),
                null,
                "^.*\\.csv", _("tutti.file.csv")
        );
        boolean doAction = file != null;
        if (doAction) {
            super.prepareAction(event);
        }
        return doAction;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        super.releaseAction(event);
        file = null;
    }

    @Override
    protected void doAction(ActionEvent e) throws Exception {

        if (log.isInfoEnabled()) {
            log.info("Will export protocol species to file: " + file);
        }

        EditProtocolUIModel model = getModel();

        // build species protocol to export

        List<SpeciesProtocol> protocols = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : model.getRows()) {
            if (row.isValid()) {
                protocols.add(row.toBean());
            }
        }

        // import
        TuttiProtocolImportExportService service =
                getService(TuttiProtocolImportExportService.class);

        service.exportProtocolSpecies(file,
                                      protocols,
                                      model.getAllCaracteristic(),
                                      model.getAllReferentSpeciesByTaxonId());

        sendMessage(_("tutti.flash.information.species.exported.from.protocol",
                      file));
    }
}