package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: RemoveSpeciesBatchAction.java 409 2013-02-13 18:24:23Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/RemoveSpeciesBatchAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;

import java.awt.event.ActionEvent;
import java.util.Set;

import static org.nuiton.i18n.I18n._;

/**
 * To remove a species batch and all his children.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class RemoveSpeciesBatchAction extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(RemoveSpeciesBatchAction.class);

    protected RemoveSpeciesSubBatchAction removeSpeciesSubBatchAction;

    public RemoveSpeciesBatchAction(SpeciesBatchUIHandler handler) {
        super(handler,
              "removeSpeciesBatch",
              "batch-delete",
              _("tutti.action.removeSpeciesBatch"),
              _("tutti.action.removeSpeciesBatch.tip"),
              false
        );

        removeSpeciesSubBatchAction = new RemoveSpeciesSubBatchAction(handler);
    }

    @Override
    protected void doAction(ActionEvent event) {

        TuttiPersistence persistenceService =
                getContext().getService(PersistenceService.class);

        SpeciesBatchUIHandler handler = getHandler();

        JXTable table = handler.getTable();

        int rowIndex = table.getSelectedRow();

        Preconditions.checkState(rowIndex != -1,
                                 "Cant remove batch if no batch selected");

        SpeciesBatchTableModel tableModel = handler.getTableModel();
        SpeciesBatchRowModel selectedBatch = tableModel.getEntry(rowIndex);

        Preconditions.checkState(!TuttiEntities.isNew(selectedBatch),
                                 "Can't remove batch if batch is not persisted");

        if (!selectedBatch.isBatchRoot()) {

            // remove all sub batches of his parent
            SpeciesBatchRowModel parentBatch = selectedBatch.getParentBatch();

            // get parent row index
            int parentIndex = tableModel.getRowIndex(parentBatch);

            // select it
            table.setRowSelectionInterval(parentIndex, parentIndex);

            // remove all his children
            removeSpeciesSubBatchAction.doAction(event);

        } else {

            // remove selected batch and all his children

            // remove parent batch (will destroy all his childs from db)
            persistenceService.deleteSpeciesBatch(selectedBatch.getId());

            // update speciesUsed
            handler.removeFromSpeciesUsed(selectedBatch);

            // collect of rows to remove from model
            Set<SpeciesBatchRowModel> rowToRemove =
                    Sets.newHashSet(selectedBatch);

            handler.collectChilds(selectedBatch, rowToRemove);

            // remove all rows from the model
            getModel().getRows().removeAll(rowToRemove);

            // refresh table from parent batch row index to the end
            tableModel.fireTableDataChanged();

            if (tableModel.getRowCount() > 0) {

                // select first row
                AbstractSelectTableAction.doSelectCell(table, 0, 0);
            } else {

                table.clearSelection();
            }

            if (table.isEditing()) {

                // but no edit it
                table.getCellEditor().stopCellEditing();
            }

        }
    }

}
