package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: SaveCatchBatchAction.java 389 2013-02-11 08:14:47Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/SaveCatchBatchAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.event.ActionEvent;

import static org.nuiton.i18n.I18n._;

/**
 * To save a {@link CatchBatch}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class SaveCatchBatchAction extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(SaveCatchBatchAction.class);


    /**
     * A flag to update ui after create or save the edit catch batch.
     *
     * @since 1.0
     */
    protected boolean updateUI;

    public SaveCatchBatchAction(EditCatchesUIHandler handler) {
        super(handler,
              "saveCatchBatch",
              "save",
              _("tutti.action.saveCatchBatch"),
              _("tutti.action.saveCatchBatch.tip"),
              true
        );
    }

    public void setUpdateUI(boolean updateUI) {
        this.updateUI = updateUI;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        updateUI = true;
        super.releaseAction(event);
    }

    @Override
    protected void doAction(ActionEvent event) {

        EditCatchesUIHandler handler = getHandler();

        TuttiBeanMonitor<EditCatchesUIModel> monitor =
                handler.getCatchBatchMonitor();

        // previous fishingOperation was modified, let's save it
        EditCatchesUIModel beanToSave = monitor.getBean();

        // must save when bean is new or was modifiy and is valid
        boolean mustSave = (beanToSave.isCreate() || beanToSave.isModify()) &&
                           beanToSave.isValid();

        if (mustSave) {

            PersistenceService persistenceService =
                    getService(PersistenceService.class);

            CatchBatch catchBatch = beanToSave.toBean();

            if (log.isInfoEnabled()) {
                log.info("FishingOperation " + catchBatch.getId() +
                         " was modified, will save it.");
            }

            getHandler().showInformationMessage(
                    "[ Captures - Caractéristiques générales ] " +
                    "Sauvegarde des modifications du résumé de la capture.");

            persistenceService.saveCatchBatch(catchBatch);

            monitor.clearModified();
            getModel().setModify(false);
        }

        getUI().getSpeciesTabContent().getHandler().clearTableSelection();

    }

}