package fr.ifremer.tutti.ui.swing;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.StatusMessagePanel;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageWidget;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class MainUI extends JFrame implements TuttiUI<TuttiUIContext, MainUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MENU_ACTIONS_ENABLED = "menuActions.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_CATCHES_ENABLED = "menuActionEditCatches.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_CRUISE_ENABLED = "menuActionEditCruise.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_PROGRAM_ENABLED = "menuActionEditProgram.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_PROTOCOL_ENABLED = "menuActionEditProtocol.enabled";
    public static final String BINDING_MENU_ACTION_MANAGE_DB_ENABLED = "menuActionManageDb.enabled";
    public static final String BINDING_MENU_ACTION_SELECT_CRUISE_ENABLED = "menuActionSelectCruise.enabled";
    public static final String BINDING_MENU_ACTION_VALIDATE_CATCHES_ENABLED = "menuActionValidateCatches.enabled";
    public static final String BINDING_MENU_ADMINISTRATION_ENABLED = "menuAdministration.enabled";
    public static final String BINDING_MENU_IMPORT_TEMPORARY_REFERENTIAL_ENABLED = "menuImportTemporaryReferential.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(MainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTitledPanel body;
    protected JToolBar bottomBar;
    protected MainUIHandler handler;
    protected MainUI mainFrame = this;
    protected JMenuBar menu;
    protected JMenuItem menuActionEditCatches;
    protected JMenuItem menuActionEditCruise;
    protected JMenuItem menuActionEditProgram;
    protected JMenuItem menuActionEditProtocol;
    protected JMenuItem menuActionManageDb;
    protected JMenuItem menuActionSelectCruise;
    protected JMenuItem menuActionUpdate;
    protected JMenuItem menuActionValidateCatches;
    protected JMenu menuActions;
    protected JMenu menuAdministration;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileExit;
    protected JMenu menuHelp;
    protected JMenuItem menuHelpAbout;
    protected JMenuItem menuHelpSite;
    protected JMenuItem menuImportTemporaryReferential;
    protected TuttiUIContext model;
    protected StatusMessagePanel status;
    protected SwingValidatorMessageWidget validatorMessageWidget;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        protected void $afterCompleteSetup() {
            getHandler().afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MainUI(TuttiUIContext context) {
        setContextValue(context);
                MainUIHandler handler = new MainUIHandler(context, this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public MainUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI() {
        $initialize();
    }

    public MainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuFileConfiguration(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showConfig();
    }

    public void doActionPerformed__on__menuFileExit(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().closeTutti();
    }

    public void doActionPerformed__on__menuHelpAbout(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAbout();
    }

    public void doActionPerformed__on__menuHelpSite(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().gotoSite();
    }

    public void doWindowClosing__on__mainFrame(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().closeTutti();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXTitledPanel getBody() {
        return body;
    }

    public JToolBar getBottomBar() {
        return bottomBar;
    }

    public MainUIHandler getHandler() {
        return handler;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenuItem getMenuActionEditCatches() {
        return menuActionEditCatches;
    }

    public JMenuItem getMenuActionEditCruise() {
        return menuActionEditCruise;
    }

    public JMenuItem getMenuActionEditProgram() {
        return menuActionEditProgram;
    }

    public JMenuItem getMenuActionEditProtocol() {
        return menuActionEditProtocol;
    }

    public JMenuItem getMenuActionManageDb() {
        return menuActionManageDb;
    }

    public JMenuItem getMenuActionSelectCruise() {
        return menuActionSelectCruise;
    }

    public JMenuItem getMenuActionUpdate() {
        return menuActionUpdate;
    }

    public JMenuItem getMenuActionValidateCatches() {
        return menuActionValidateCatches;
    }

    public JMenu getMenuActions() {
        return menuActions;
    }

    public JMenu getMenuAdministration() {
        return menuAdministration;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenu getMenuHelp() {
        return menuHelp;
    }

    public JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public JMenuItem getMenuImportTemporaryReferential() {
        return menuImportTemporaryReferential;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public StatusMessagePanel getStatus() {
        return status;
    }

    public SwingValidatorMessageWidget getValidatorMessageWidget() {
        return validatorMessageWidget;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBottomBar() {
        if (!allComponentsCreated) {
            return;
        }
        bottomBar.add(validatorMessageWidget);
    }

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(bottomBar);
        add(body, BorderLayout.CENTER);
        add(status, BorderLayout.SOUTH);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuActions);
        menu.add(menuAdministration);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuActions() {
        if (!allComponentsCreated) {
            return;
        }
        menuActions.add(menuActionSelectCruise);
        menuActions.add(menuActionEditProgram);
        menuActions.add(menuActionEditCruise);
        menuActions.add(menuActionEditProtocol);
        menuActions.add(menuActionEditCatches);
        menuActions.add(menuActionValidateCatches);
    }

    protected void addChildrenToMenuAdministration() {
        if (!allComponentsCreated) {
            return;
        }
        menuAdministration.add(menuImportTemporaryReferential);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuActionUpdate);
        menuFile.add($JSeparator0);
        menuFile.add(menuActionManageDb);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void createBody() {
        $objectMap.put("body", body = new JXTitledPanel());
        
        body.setName("body");
    }

    protected void createBottomBar() {
        $objectMap.put("bottomBar", bottomBar = new JToolBar());
        
        bottomBar.setName("bottomBar");
        bottomBar.setFloatable(false);
        bottomBar.setBorderPainted(false);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(MainUIHandler.class));
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuActionEditCatches() {
        $objectMap.put("menuActionEditCatches", menuActionEditCatches = new JMenuItem());
        
        menuActionEditCatches.setName("menuActionEditCatches");
        menuActionEditCatches.putClientProperty("tuttiAction", EditSelectedCruiseCatchesAction.class);
    }

    protected void createMenuActionEditCruise() {
        $objectMap.put("menuActionEditCruise", menuActionEditCruise = new JMenuItem());
        
        menuActionEditCruise.setName("menuActionEditCruise");
        menuActionEditCruise.putClientProperty("tuttiAction", EditSelectedCruiseAction.class);
    }

    protected void createMenuActionEditProgram() {
        $objectMap.put("menuActionEditProgram", menuActionEditProgram = new JMenuItem());
        
        menuActionEditProgram.setName("menuActionEditProgram");
        menuActionEditProgram.putClientProperty("tuttiAction", EditSelectedProgramAction.class);
    }

    protected void createMenuActionEditProtocol() {
        $objectMap.put("menuActionEditProtocol", menuActionEditProtocol = new JMenuItem());
        
        menuActionEditProtocol.setName("menuActionEditProtocol");
        menuActionEditProtocol.putClientProperty("tuttiAction", EditSelectedProtocolAction.class);
    }

    protected void createMenuActionManageDb() {
        $objectMap.put("menuActionManageDb", menuActionManageDb = new JMenuItem());
        
        menuActionManageDb.setName("menuActionManageDb");
        menuActionManageDb.putClientProperty("tuttiAction", ManageDbAction.class);
    }

    protected void createMenuActionSelectCruise() {
        $objectMap.put("menuActionSelectCruise", menuActionSelectCruise = new JMenuItem());
        
        menuActionSelectCruise.setName("menuActionSelectCruise");
        menuActionSelectCruise.putClientProperty("tuttiAction", SelectCruiseAction.class);
    }

    protected void createMenuActionUpdate() {
        $objectMap.put("menuActionUpdate", menuActionUpdate = new JMenuItem());
        
        menuActionUpdate.setName("menuActionUpdate");
        menuActionUpdate.putClientProperty("tuttiAction", UpdateApplicationAction.class);
    }

    protected void createMenuActionValidateCatches() {
        $objectMap.put("menuActionValidateCatches", menuActionValidateCatches = new JMenuItem());
        
        menuActionValidateCatches.setName("menuActionValidateCatches");
        menuActionValidateCatches.putClientProperty("tuttiAction", ValidateSelectedCruiseCatchesAction.class);
    }

    protected void createMenuActions() {
        $objectMap.put("menuActions", menuActions = new JMenu());
        
        menuActions.setName("menuActions");
        menuActions.setText(_("tutti.menu.actions"));
        menuActions.setMnemonic(65);
        menuActions.setToolTipText(_("tutti.menu.actions.tip"));
    }

    protected void createMenuAdministration() {
        $objectMap.put("menuAdministration", menuAdministration = new JMenu());
        
        menuAdministration.setName("menuAdministration");
        menuAdministration.setText(_("tutti.menu.administration"));
        menuAdministration.setMnemonic(65);
        menuAdministration.setToolTipText(_("tutti.menu.administration.tip"));
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(_("tutti.menu.file"));
        menuFile.setMnemonic(70);
        menuFile.setToolTipText(_("tutti.menu.file.tip"));
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("tutti.action.configuration"));
        menuFileConfiguration.setMnemonic(67);
        menuFileConfiguration.setToolTipText(_("tutti.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("tutti.action.exit"));
        menuFileExit.setToolTipText(_("tutti.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("tutti.menu.help"));
        menuHelp.setMnemonic(69);
        menuHelp.setToolTipText(_("tutti.menu.help.tip"));
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("tutti.action.about"));
        menuHelpAbout.setMnemonic(65);
        menuHelpAbout.setToolTipText(_("tutti.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("tutti.action.site"));
        menuHelpSite.setMnemonic(83);
        menuHelpSite.setToolTipText(_("tutti.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
    }

    protected void createMenuImportTemporaryReferential() {
        $objectMap.put("menuImportTemporaryReferential", menuImportTemporaryReferential = new JMenuItem());
        
        menuImportTemporaryReferential.setName("menuImportTemporaryReferential");
        menuImportTemporaryReferential.putClientProperty("tuttiAction", ImportTemporaryReferentialAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createStatus() {
        $objectMap.put("status", status = new StatusMessagePanel());
        
        status.setName("status");
    }

    protected void createValidatorMessageWidget() {
        $objectMap.put("validatorMessageWidget", validatorMessageWidget = new SwingValidatorMessageWidget());
        
        validatorMessageWidget.setName("validatorMessageWidget");
        validatorMessageWidget.setFocusPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuActions();
        addChildrenToMenuAdministration();
        addChildrenToMenuHelp();
        addChildrenToBottomBar();
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        menuFileConfiguration.setIcon(SwingUtil.createActionIcon("config"));
        menuFileExit.setIcon(SwingUtil.createActionIcon("exit"));
        menuHelpSite.setIcon(SwingUtil.createActionIcon("site"));
        menuHelpAbout.setIcon(SwingUtil.createActionIcon("about"));
        bottomBar.setMargin(new java.awt.Insets(0, 0, 0, 5));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("mainFrame", mainFrame);
        createModel();
        createHandler();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuActionUpdate();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuActionManageDb();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileExit();
        createMenuActions();
        createMenuActionSelectCruise();
        createMenuActionEditProgram();
        createMenuActionEditCruise();
        createMenuActionEditProtocol();
        createMenuActionEditCatches();
        createMenuActionValidateCatches();
        createMenuAdministration();
        createMenuImportTemporaryReferential();
        createMenuHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createBottomBar();
        createValidatorMessageWidget();
        createBody();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,600);
        SwingUtil.setComponentWidth(mainFrame,800);
        setTitle(_("tutti.application.name"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 10 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 10 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_MANAGE_DB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionManageDb.setEnabled(model.getScreen() != TuttiScreen.MANAGE_DB);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTIONS_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActions.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_SELECT_CRUISE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionSelectCruise.setEnabled(model.getScreen() != TuttiScreen.SELECT_CRUISE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_PROGRAM_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("programFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditProgram.setEnabled(model.getScreen() != TuttiScreen.EDIT_PROGRAM && model.isProgramFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("programFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_CRUISE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditCruise.setEnabled(model.getScreen() != TuttiScreen.EDIT_CRUISE && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_PROTOCOL_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("protocolFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditProtocol.setEnabled(model.getScreen() != TuttiScreen.EDIT_PROTOCOL && model.isProtocolFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("protocolFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("validationContext", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditCatches.setEnabled((
                                  !TuttiUIContext.VALIDATION_CONTEXT_EDIT.equals(model.getValidationContext())
                                  || model.getScreen() != TuttiScreen.EDIT_FISHING_OPERATION
                                  ) && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("validationContext", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_VALIDATE_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("validationContext", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionValidateCatches.setEnabled((
                      !TuttiUIContext.VALIDATION_CONTEXT_VALIDATE.equals(model.getValidationContext())
                      || model.getScreen() != TuttiScreen.EDIT_FISHING_OPERATION
                      ) && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("validationContext", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ADMINISTRATION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuAdministration.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_IMPORT_TEMPORARY_REFERENTIAL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuImportTemporaryReferential.setEnabled(model.getScreen() != TuttiScreen.IMPORT_TEMPORARY_REFERENTIAL);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
    }

}